/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    public static final float DEFAULT_SCALE = 0.8f;
    public static final float MINECRAFT_SCALE = 0.02666667f;
    private IXaeroMinimap modMain;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
    }

    public void render(XaeroMinimapSession minimapSession, float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS)) {
                return;
            }
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            Entity entity = mc.func_175606_aa();
            double actualEntityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
            double actualEntityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
            double actualEntityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
            Vec3d cameraPos = ActiveRenderInfo.getCameraPosition();
            double d3 = cameraPos.field_72450_a;
            double d4 = cameraPos.field_72448_b;
            double d5 = cameraPos.field_72449_c;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            boolean lookingBack = mc.field_71474_y.field_74320_O == 2;
            float yaw = (float)(lookingBack ? 0 : 180) + (float)((double)entity.field_70126_B + (double)(entity.field_70177_z - entity.field_70126_B) * (double)partial);
            float pitch = (float)(lookingBack ? -1 : 1) * (float)((double)entity.field_70127_C + (double)(entity.field_70125_A - entity.field_70127_C) * (double)partial);
            double fov = mc.field_71474_y.field_74334_X;
            int screenHeight = mc.field_71440_d;
            float cameraAngleYaw = MathHelper.func_76142_g((float)(yaw - 180.0f));
            float cameraAnglePitch = MathHelper.func_76142_g((float)pitch);
            Vec3d lookVector = entity.func_70040_Z();
            if (lookingBack) {
                lookVector = lookVector.func_186678_a(-1.0);
            }
            double clampDepth = this.modMain.getSettings().getWaypointsClampDepth(fov, screenHeight);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth);
                    }
                } else {
                    this.renderWaypointsList(waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth);
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    this.renderWaypointsList(modCustomWaypoints.values(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch, fov, screenHeight, cameraAngleYaw, cameraAnglePitch, lookVector, clampDepth);
                }
            }
            RenderHelper.func_74518_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vec3d lookVector, double clampDepth) {
        for (Waypoint w : list) {
            this.renderWaypointIngame(cameraAngleYaw, cameraAnglePitch, lookVector, w, this.modMain, clampDepth, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityX, actualEntityY, actualEntityZ, yaw, pitch);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, float cameraAnglePitch, Vec3d lookVector, Waypoint w, IXaeroMinimap modMain, double depthClamp, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tessellator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, float yaw, float pitch) {
        double wpRenderZ;
        float offZ;
        double wpRenderY;
        float offY;
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        double wpRenderX = (double)w.getX(dimDiv) + 0.5 - actualEntityX;
        float offX = (float)(wpRenderX - d3);
        double depth = (double)offX * lookVector.field_72450_a + (double)(offY = (float)((wpRenderY = (double)w.getY() + 1.0 - actualEntityY) - d4)) * lookVector.field_72448_b + (double)(offZ = (float)((wpRenderZ = (double)w.getZ(dimDiv) + 0.5 - actualEntityZ) - d5)) * lookVector.field_72449_c;
        if (depth < 0.0) {
            return;
        }
        double correctOffX = wpRenderX;
        double correctOffY = actualEntityY - (double)w.getY();
        double correctOffZ = wpRenderZ;
        double correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + correctOffZ * correctOffZ);
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        double waypointsDistance = modMain.getSettings().getMaxWaypointsDistance();
        if (w.getType() == 0 && !w.isGlobal() && waypointsDistance != 0.0 && distance2D > waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0 && distance2D < modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float originalOffY = offY;
        GlStateManager.func_179094_E();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (depth > depthClamp) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (depth > maxDistance) {
                zoomer2 = (float)(maxDistance / depthClamp);
                float zoomer = (float)(maxDistance / depth);
                offX *= zoomer;
                offY *= zoomer;
                offY += entity.func_70047_e() * (1.0f - zoomer);
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(depth / depthClamp);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float verticalAngle = (float)Math.toDegrees(Math.atan((double)(-originalOffY) / (distance2D == 0.0 ? 1.0E-5 : distance2D)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        GlStateManager.func_179137_b((double)(d3 + (double)offX), (double)(d4 + (double)offY), (double)(d5 + (double)offZ));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(renderManager.field_78732_j * (float)(Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? -1 : 1)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.02666667f, (float)-0.02666667f, (float)1.0f);
        GlStateManager.func_179152_a((float)zoomer2, (float)zoomer2, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)1.0f);
        this.drawIconInWorld(w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        int t;
        double ingameScale = settings.waypointsIngameScale;
        double distanceScale = settings.waypointsDistanceScale;
        double nameScale = settings.waypointsNameScale;
        int ingameOpacity = settings.waypointOpacityIngame;
        GlStateManager.func_179139_a((double)ingameScale, (double)ingameScale, (double)1.0);
        int addedFrame = 0;
        if (Minecraft.func_71410_x().func_152349_b()) {
            textSize *= 1.5f;
        }
        int c = ModSettings.COLORS[w.getColor()];
        float l = (float)(c >> 16 & 0xFF) / 255.0f;
        float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
        float j1 = (float)(c & 0xFF) / 255.0f;
        if (w.getType() == 0) {
            GlStateManager.func_179152_a((float)textSize, (float)textSize, (float)textSize);
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, s);
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(w.getSymbol(), -s, -8, -1);
        } else if (w.getType() == 1) {
            GlStateManager.func_179131_c((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)ingameOpacity / 100.0f) / 255.0f));
            GlStateManager.func_179090_x();
            addedFrame = this.renderColorBackground(vertexBuffer, tessellator, addedFrame, 4);
            GlStateManager.func_179098_w();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            this.renderTexturedIcon(vertexBuffer, tessellator, addedFrame, 0, 78);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!showDistance) {
                name = w.getLocalizedName();
            }
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        boolean showingName = name.length() > 0;
        GlStateManager.func_179109_b((float)0.0f, (float)(1 + addedFrame), (float)0.0f);
        if (w.getType() != 0) {
            GlStateManager.func_179152_a((float)textSize, (float)textSize, (float)1.0f);
        }
        if (showingName) {
            GlStateManager.func_179139_a((double)nameScale, (double)nameScale, (double)1.0);
            t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_78276_b(name, -t, 0, -1);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)(1.0 / nameScale), (double)(1.0 / nameScale), (double)1.0);
            GlStateManager.func_179147_l();
        }
        if (distance.length() > 0) {
            GlStateManager.func_179139_a((double)distanceScale, (double)distanceScale, (double)1.0);
            t = fontrenderer.func_78256_a(distance) / 2;
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            fontrenderer.func_78276_b(distance, -t, 1, -1);
        }
    }

    private int renderColorBackground(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int s) {
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        if (s > 4) {
            addedFrame = s - 4;
        }
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_181675_d();
        tessellator.func_78381_a();
        return addedFrame;
    }

    private void renderTexturedIcon(BufferBuilder vertexBuffer, Tessellator tessellator, int addedFrame, int textureX, int textureY) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181675_d();
        vertexBuffer.func_181662_b(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181675_d();
        vertexBuffer.func_181662_b(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)textureY * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

