/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderDragon;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;

public class EntityIconPrerenderer {
    private static final ModelRenderer[] ONE_RENDERER_ARRAY = new ModelRenderer[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private ImprovedFramebuffer modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer iconScaleFramebuffer;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private float r;
    private float g;
    private float b;
    private float a;

    public EntityIconPrerenderer() {
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.iconScaleFramebuffer = new ImprovedFramebuffer(64, 64, false);
        OpenGLException.checkGLError();
        GlStateManager.func_179150_h((int)this.iconScaleFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.modelRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.field_147621_c, (int)this.modelRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_179144_i((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_179144_i((int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public int prerender(Render entityRenderer, Entity entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug) {
        ModelBase entityModel = null;
        if (entityRenderer instanceof RenderLivingBase) {
            entityModel = ((RenderLivingBase)entityRenderer).func_177087_b();
        } else if (entityRenderer instanceof RenderDragon) {
            entityModel = new ModelDragon(0.0f);
        }
        if (entityModel == null) {
            return -1;
        }
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        ImprovedFramebuffer iconScaleFramebuffer = this.iconScaleFramebuffer;
        int finalIconSize = iconScaleFramebuffer.field_147621_c;
        OpenGLException.checkGLError();
        modelRenderFramebuffer.func_147610_a(true);
        int farPlane = 500;
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)finalIconSize, (double)0.0, (double)finalIconSize, (double)-1.0, (double)farPlane);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        if (Minecraft.func_71410_x().func_175598_ae().field_78734_h != null) {
            GlStateManager.func_179094_E();
            try {
                OpenGLException.checkGLError();
                entityRenderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            }
            catch (Exception e) {
                System.out.println("Exception when calling the full entity renderer before rendering the icon. " + EntityList.func_191301_a((Entity)entity));
            }
            GlStateManager.func_179121_F();
            while (GL11.glGetError() != 0) {
            }
        } else {
            System.out.println("Render info was null for entity " + EntityList.func_191301_a((Entity)entity));
        }
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33984);
        RenderHelper.func_74518_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16640);
        GlStateManager.func_179147_l();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (debug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-65536);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        }
        this.a = 1.0f;
        this.b = 1.0f;
        this.g = 1.0f;
        this.r = 1.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(finalIconSize / 2), (float)(finalIconSize / 2), (float)-450.0f);
        GlStateManager.func_179152_a((float)(finalIconSize / 2), (float)(finalIconSize / 2), (float)-1.0f);
        if (scale < 1.0f) {
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        }
        EntityIconDefinitions.customTransformation(entityModel, entity, this);
        boolean preparedForRender = false;
        try {
            entityModel.func_78087_a(0.0f, 0.0f, (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f, entity);
            if (entity instanceof EntityLivingBase) {
                entityModel.func_78086_a((EntityLivingBase)entity, 0.0f, 0.0f, 1.0f);
            }
            OpenGLException.checkGLError();
            preparedForRender = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean renderedSomething = preparedForRender && this.renderModel(entityRenderer, entityModel, entity);
        EntityIconDefinitions.customPostRenderTransformation(entityModel, entity);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (debug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)9.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711936);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        }
        modelRenderFramebuffer.func_147609_e();
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        int entityScaledIconTextureId = -1;
        if (renderedSomething) {
            iconRenderFramebuffer.func_147610_a(true);
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16384);
            GlStateManager.func_179084_k();
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)18.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16776961);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.func_147612_c();
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                    if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                    helper.drawMyTexturedModalRect(shadowOffsetX, finalIconSize + shadowOffsetY, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)27.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711681);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_179147_l();
            iconRenderFramebuffer.func_147609_e();
            iconRenderFramebuffer.func_147612_c();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.func_179144_i((int)0);
            entityScaledIconTextureId = GlStateManager.func_179146_y();
            OpenGLException.checkGLError();
            GlStateManager.func_179144_i((int)entityScaledIconTextureId);
            EntityIconPrerenderer.setupIconTextureParams();
            OpenGLException.checkGLError();
            GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)iconScaleFramebuffer.field_147621_c, (int)iconScaleFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            GlStateManager.func_179144_i((int)0);
            OpenGLException.checkGLError();
            iconScaleFramebuffer.func_147610_a(true);
            iconScaleFramebuffer.setFramebufferTexture(entityScaledIconTextureId);
            iconScaleFramebuffer.func_147611_b();
            iconRenderFramebuffer.func_147612_c();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            helper.drawMyTexturedModalRect(0.0f, finalIconSize, 0, 0, finalIconSize, -finalIconSize, finalIconSize, finalIconSize);
            if (debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)36.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-256);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179144_i((int)0);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        helper.defaultOrtho();
        GlStateManager.func_179128_n((int)5888);
        iconScaleFramebuffer.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
        return entityScaledIconTextureId;
    }

    public static void setupIconTextureParams() {
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    private boolean renderModel(Render entityRenderer, ModelBase entityModel, Entity entity) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck = EntityIconDefinitions.forceFieldCheck(entityModel);
        boolean isChildBU = entityModel.field_78091_s;
        entityModel.field_78091_s = false;
        ArrayList<ModelRenderer> renderedModels = new ArrayList<ModelRenderer>();
        ModelRenderer mainPart = null;
        boolean fullModelIcon = EntityIconDefinitions.fullModelIcon(entityModel);
        ResourceLocation entityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (entityTexture != null) {
            ModelRenderer headRenderer;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(entityTexture);
            if (!fullModelIcon && !forceFieldCheck && entityModel instanceof ModelBiped) {
                mainPart = headRenderer = ((ModelBiped)entityModel).field_78116_c;
                ModelRenderer headWearRenderer = ((ModelBiped)entityModel).field_178720_f;
                this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                this.entityModelPartsRenderer.renderPart(headWearRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
            } else if (!fullModelIcon && !forceFieldCheck && entityModel instanceof ModelQuadruped) {
                headRenderer = ((ModelQuadruped)entityModel).field_78150_a;
                if (headRenderer != null) {
                    mainPart = headRenderer;
                    this.entityModelPartsRenderer.renderPart(headRenderer, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                }
            } else {
                if (mainPart == null) {
                    mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, EntityIconDefinitions.HEAD_HARDCODED_NAMES, true);
                }
                mainPart = this.searchSuperclassFields(entityModel, renderedModels, mainPart, fullModelIcon ? null : EntityIconDefinitions.HEAD_PARTS_HARDCODED_NAMES, false);
            }
        }
        if ((extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(this, entityRenderer, entity, entityModel, this.entityModelPartsRenderer, renderedModels, mainPart);
        }
        GlStateManager.func_179144_i((int)0);
        entityModel.field_78091_s = isChildBU;
        return !renderedModels.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelRenderer[] handleDeclaredField(Field f, ModelBase entityModel) throws IllegalArgumentException, IllegalAccessException {
        boolean accessibleBU = f.isAccessible();
        try {
            f.setAccessible(true);
            Object fieldValue = f.get(entityModel);
            if (fieldValue instanceof ModelRenderer[]) {
                ModelRenderer[] modelRendererArray = (ModelRenderer[])fieldValue;
                return modelRendererArray;
            }
            EntityIconPrerenderer.ONE_RENDERER_ARRAY[0] = (ModelRenderer)fieldValue;
            ModelRenderer[] modelRendererArray = ONE_RENDERER_ARRAY;
            return modelRendererArray;
        }
        finally {
            f.setAccessible(accessibleBU);
        }
    }

    public ModelRenderer searchSuperclassFields(ModelBase entityModel, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, ImmutableList<String> filter, boolean justOne) {
        Class<?> modelClass = entityModel.getClass();
        while (modelClass != ModelBase.class) {
            Field[] declaredModelFields = modelClass.getDeclaredFields();
            mainPart = this.handleFields(entityModel, declaredModelFields, renderedModels, mainPart, filter, justOne);
            if ((!justOne || mainPart == null) && (modelClass = modelClass.getSuperclass()) != null) continue;
        }
        return mainPart;
    }

    public ModelRenderer handleFields(ModelBase entityModel, Field[] declaredModelFields, ArrayList<ModelRenderer> renderedModels, ModelRenderer mainPart, ImmutableList<String> filter, boolean justOne) {
        block7: for (Field f : declaredModelFields) {
            try {
                f.getType().asSubclass(ModelRenderer.class);
            }
            catch (ClassCastException cce) {
                try {
                    f.getType().asSubclass(ModelRenderer[].class);
                }
                catch (ClassCastException cce1) {
                    continue;
                }
            }
            try {
                ModelRenderer[] renderers;
                String comparisonName = f.getDeclaringClass().getName() + ";" + f.getName();
                if (filter != null && !filter.contains((Object)comparisonName)) continue;
                for (ModelRenderer mr : renderers = EntityIconPrerenderer.handleDeclaredField(f, entityModel)) {
                    if (mainPart == null) {
                        mainPart = mr;
                    }
                    this.entityModelPartsRenderer.renderPart(mr, renderedModels, mainPart, this.r, this.g, this.b, this.a);
                    if (justOne) break block7;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return mainPart;
    }

    public void setRGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }
}

