/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import net.minecraft.client.Minecraft;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapInterface;

public class MinimapInterfaceInstance
extends InterfaceInstance {
    private XaeroMinimapSession minimapSession;
    private IXaeroMinimap modMain;

    public MinimapInterfaceInstance(MinimapInterface inter, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        super(inter);
        this.minimapSession = minimapSession;
        this.modMain = modMain;
    }

    @Override
    public void render(int width, int height, double scale, float partial) {
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(Effects.NO_MINIMAP)) {
            return;
        }
        this.minimapSession.getMinimapProcessor().onRender(this.inter.getX(), this.inter.getY(), width, height, (int)scale, this.getInterfaceWidth(scale), this.getW(scale), partial);
        super.render(width, height, scale, partial);
    }

    @Override
    public int getW(double scale) {
        return (int)((double)((float)this.getInterfaceWidth(scale) * this.modMain.getSettings().getMinimapScale(scale)) / scale);
    }

    @Override
    public int getH(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getWC(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getHC(double scale) {
        return this.getH(scale);
    }

    @Override
    public int getW0(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getH0(double scale) {
        return this.getH(scale);
    }

    public int getInterfaceWidth(double scale) {
        return this.minimapSession.getMinimapProcessor().getMinimapSize(scale) / 2 + 18;
    }

    @Override
    public int getSize(double scale) {
        int w = this.getInterfaceWidth(scale);
        return w * w;
    }
}

