/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import xaero.common.gui.KeySortableByOther;
import xaero.common.minimap.waypoints.WaypointWorld;

public class GuiWaypointSets {
    private int currentSet;
    private String[] options;

    public GuiWaypointSets(boolean canCreate, WaypointWorld currentWorld) {
        int i;
        String c = currentWorld.getCurrent();
        int size = currentWorld.getSets().size() + (canCreate ? 1 : 0);
        String[] keys = currentWorld.getSets().keySet().toArray(new String[0]);
        ArrayList<KeySortableByOther<String>> keysList = new ArrayList<KeySortableByOther<String>>();
        for (i = 0; i < keys.length; ++i) {
            String key = keys[i];
            keysList.add(new KeySortableByOther<String>(key, new Comparable[]{I18n.func_135052_a((String)key, (Object[])new Object[0]).toLowerCase()}));
        }
        Collections.sort(keysList);
        this.options = new String[size];
        for (i = 0; i < keysList.size(); ++i) {
            this.options[i] = (String)((KeySortableByOther)keysList.get(i)).getKey();
            if (!this.options[i].equals(c)) continue;
            this.currentSet = i;
        }
        if (canCreate) {
            this.options[this.options.length - 1] = "\u00a78" + I18n.func_135052_a((String)"gui.xaero_create_set", (Object[])new Object[0]);
        }
    }

    public String getCurrentSetKey() {
        return this.options[this.currentSet];
    }

    public int getCurrentSet() {
        return this.currentSet;
    }

    public void setCurrentSet(int currentSet) {
        this.currentSet = currentSet;
    }

    public String[] getOptions() {
        return this.options;
    }
}

