/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.recipe;

import com.google.gson.JsonObject;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import org.bensam.tpworks.util.ModConfig;

public class RecipeTeleportationItem
extends ShapedRecipes {
    public RecipeTeleportationItem(int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super("", width, height, ingredients, result);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (inv.func_174922_i() == 3 && inv.func_174923_h() == 3) {
            if (this.checkMatch(inv, false)) {
                return true;
            }
            if (this.checkMatch(inv, true)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting craftingInventory, boolean isMirrored) {
        NonNullList ingredients = this.func_192400_c();
        int height = 3;
        int width = 3;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                ItemStack craftingItem = craftingInventory.func_70463_b(i, j);
                if (craftingItem != null && craftingItem.func_77973_b() == Items.field_151079_bi && ModConfig.worldSettings.craftingDifficulty == ModConfig.WorldSettings.CraftingDifficulty.HARD) {
                    return false;
                }
                int stride = j * width;
                Ingredient ingredient = Ingredient.field_193370_a;
                ingredient = isMirrored ? (Ingredient)ingredients.get(width - 1 - i + stride) : (Ingredient)ingredients.get(i + stride);
                if (ingredient.apply(craftingItem)) continue;
                return false;
            }
        }
        return true;
    }

    public static RecipeTeleportationItem deserialize(JsonObject json) {
        ShapedRecipes recipe = ShapedRecipes.func_193362_a((JsonObject)json);
        return new RecipeTeleportationItem(recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b());
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return RecipeTeleportationItem.deserialize(json);
        }
    }
}

