/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.capability.teleportation.ITeleportationTileEntity;

public class PacketUpdateTeleportTileEntity
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private int isStored;
    private int isSender;

    public PacketUpdateTeleportTileEntity(BlockPos pos, int dimension, @Nullable Boolean isStored, @Nullable Boolean isSender) {
        this.pos = pos;
        this.dimension = dimension;
        int n = isStored == null ? -1 : (this.isStored = isStored != false ? 1 : 0);
        this.isSender = isSender == null ? -1 : (isSender != false ? 1 : 0);
    }

    public PacketUpdateTeleportTileEntity() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dimension = buf.readInt();
        this.isStored = buf.readByte();
        this.isSender = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        buf.writeByte(this.isStored);
        buf.writeByte(this.isSender);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateTeleportTileEntity, IMessage> {
        public IMessage onMessage(PacketUpdateTeleportTileEntity message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (message.dimension == world.field_73011_w.getDimension()) {
                    TileEntity te = world.func_175625_s(message.pos);
                    if (te instanceof ITeleportationTileEntity) {
                        if (message.isStored >= 0) {
                            ((ITeleportationTileEntity)te).setStoredByPlayer(message.isStored != 0);
                        }
                        if (message.isSender >= 0) {
                            ((ITeleportationTileEntity)te).setSender(message.isSender != 0);
                            world.func_175704_b(message.pos, message.pos);
                        }
                    }
                } else {
                    TeleportationWorks.MOD_LOGGER.debug("Skipping update of teleporting tile entity for player {} for TE at {} in dimension {}", (Object)Minecraft.func_71410_x().field_71439_g.getDisplayNameString(), (Object)message.pos, (Object)message.dimension);
                }
            });
            return null;
        }
    }
}

