/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.entity;

import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.item.ModItems;
import org.bensam.tpworks.potion.ModPotions;
import org.bensam.tpworks.potion.PotionTeleportation;

public class EntityTeleportationTippedArrow
extends EntityTippedArrow {
    protected TileEntity sourceTileEntity;
    protected TeleportDestination teleportDestination;

    public EntityTeleportationTippedArrow(World world) {
        super(world);
        this.func_70239_b(this.func_70242_d() * 0.25);
    }

    public EntityTeleportationTippedArrow(World world, EntityLivingBase shooter) {
        super(world, shooter);
        this.func_70239_b(this.func_70242_d() * 0.25);
        if (shooter != null) {
            this.teleportDestination = TeleportationHelper.getActiveDestination((Entity)shooter, true);
        }
    }

    public EntityTeleportationTippedArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_70239_b(this.func_70242_d() * 0.25);
    }

    public EntityTeleportationTippedArrow(World world, double x, double y, double z, IBlockSource source) {
        super(world, x, y, z);
        this.func_70239_b(this.func_70242_d() * 0.25);
        this.sourceTileEntity = source.func_150835_j();
        if (this.sourceTileEntity != null) {
            this.teleportDestination = TeleportationHelper.getActiveDestination(this.sourceTileEntity, true);
        }
    }

    public TileEntity getSourceTileEntity() {
        return this.sourceTileEntity;
    }

    public int func_184557_n() {
        return ModPotions.TELEPORTATION_POTION.func_76401_j();
    }

    protected void func_184548_a(EntityLivingBase entityHit) {
        World world = entityHit.field_70170_p;
        if (!world.field_72995_K) {
            PotionTeleportation potion = ModPotions.TELEPORTATION_POTION;
            Entity shooter = this.field_70250_c;
            if (shooter != null && this.teleportDestination != null) {
                potion.affectEntity((Entity)this, shooter, (Entity)entityHit, this.teleportDestination);
            } else if (this.sourceTileEntity != null && this.teleportDestination != null) {
                potion.affectEntity((Entity)this, this.sourceTileEntity, (Entity)entityHit, this.teleportDestination);
            }
        }
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((Item)ModItems.TELEPORTATION_TIPPED_ARROW);
    }
}

