/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.capability.teleportation;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.network.PacketUpdateTeleportTileEntity;

public class CommandTeleportation
extends CommandBase {
    public String func_71517_b() {
        return "td";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.td.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length <= 0) {
            throw new WrongUsageException("command.td.usage", new Object[0]);
        }
        String cmd = args[0];
        int index = -1;
        boolean affectAll = false;
        TargetType targetType = TargetType.NONE;
        if (args.length >= 2) {
            if (args[1].equals("*") || args[1].equalsIgnoreCase("all")) {
                affectAll = true;
            } else if (args[1].equalsIgnoreCase("invalid")) {
                targetType = TargetType.INVALID;
            } else if (args[1].equalsIgnoreCase("beacons")) {
                targetType = TargetType.BEACONS;
            } else if (args[1].equalsIgnoreCase("rails")) {
                targetType = TargetType.RAILS;
            } else {
                index = CommandTeleportation.func_180528_a((String)args[1], (int)1);
            }
        }
        if (StringUtils.isNumeric((CharSequence)cmd)) {
            index = CommandTeleportation.func_180528_a((String)args[0], (int)1);
            this.executeSetDestinationCommand(sender, --index);
        } else if (cmd.equalsIgnoreCase("list")) {
            this.executeListCommand(sender, --index, targetType);
        } else if (cmd.equalsIgnoreCase("delete")) {
            if (args.length < 2) {
                throw new CommandException("command.td.destination.missing", new Object[0]);
            }
            if (affectAll) {
                this.executeDeleteAllCommand(sender, false);
            } else {
                this.executeDeleteCommand(sender, --index, targetType);
            }
        } else if (cmd.equalsIgnoreCase("prev")) {
            this.executeNextCommand(sender, index == -1 ? index : -index);
        } else if (cmd.equalsIgnoreCase("next")) {
            this.executeNextCommand(sender, index == -1 ? 1 : index);
        } else {
            throw new WrongUsageException("command.td.usage", new Object[0]);
        }
    }

    public void executeSetDestinationCommand(ICommandSender sender, int destinationIndex) throws CommandException {
        EntityPlayerMP player = CommandTeleportation.func_71521_c((ICommandSender)sender);
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            int destinationCount = teleportationHandler.getDestinationCount();
            if (destinationCount == 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none", new Object[0]));
                return;
            }
            if (destinationIndex >= destinationCount) {
                throw new CommandException("command.td.destination.notFound", new Object[]{destinationIndex + 1});
            }
            TeleportDestination destination = teleportationHandler.setActiveDestination(destinationIndex);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.active.confirmation", new Object[]{teleportationHandler.getShortFormattedName((EntityPlayer)player, destination)}));
        }
    }

    public void executeListCommand(ICommandSender sender, int destinationIndex, TargetType targetType) throws CommandException {
        EntityPlayerMP player = CommandTeleportation.func_71521_c((ICommandSender)sender);
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            int destinationCount = teleportationHandler.getDestinationCount();
            if (destinationCount == 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none", new Object[0]));
                return;
            }
            if (targetType != TargetType.NONE) {
                TeleportDestination activeDestination = teleportationHandler.getActiveDestination();
                TeleportDestination.DestinationType destinationType = null;
                if (targetType == TargetType.BEACONS) {
                    destinationType = TeleportDestination.DestinationType.BEACON;
                } else if (targetType == TargetType.RAILS) {
                    destinationType = TeleportDestination.DestinationType.RAIL;
                }
                TeleportDestination destination = null;
                boolean foundOne = false;
                do {
                    if ((destination = TeleportationHelper.getNextDestination((Entity)player, destinationType, destination, null)) == null || targetType == TargetType.INVALID && teleportationHandler.validateDestination((Entity)player, destination)) continue;
                    foundOne = true;
                    TextFormatting destinationFormat = destination.equals(activeDestination) ? TextFormatting.GOLD : TextFormatting.RESET;
                    player.func_145747_a((ITextComponent)new TextComponentString(destinationFormat + teleportationHandler.getLongFormattedName((EntityPlayer)player, destination, destinationFormat)));
                } while (destination != null);
                if (!foundOne) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none_of_type", new Object[]{targetType}));
                }
            } else if (destinationIndex < 0) {
                int activeDestinationIndex = teleportationHandler.getActiveDestinationIndex();
                for (int i = 0; i < destinationCount; ++i) {
                    TeleportDestination destination = teleportationHandler.getDestinationFromIndex(i);
                    TextFormatting destinationFormat = i == activeDestinationIndex ? TextFormatting.GOLD : TextFormatting.RESET;
                    player.func_145747_a((ITextComponent)new TextComponentString(destinationFormat + Integer.toString(i + 1) + ") " + teleportationHandler.getLongFormattedName((EntityPlayer)player, destination, destinationFormat)));
                }
            } else {
                TeleportDestination destination = teleportationHandler.getDestinationFromIndex(destinationIndex);
                if (destination == null) {
                    throw new CommandException("command.td.destination.notFound", new Object[]{destinationIndex + 1});
                }
                player.func_145747_a((ITextComponent)new TextComponentString(teleportationHandler.getLongFormattedName((EntityPlayer)player, destination)));
            }
        }
    }

    public void executeDeleteCommand(ICommandSender sender, int destinationIndex, TargetType targetType) throws CommandException {
        EntityPlayerMP player = CommandTeleportation.func_71521_c((ICommandSender)sender);
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            int destinationCount = teleportationHandler.getDestinationCount();
            if (destinationCount == 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none", new Object[0]));
                return;
            }
            if (targetType != TargetType.NONE) {
                boolean foundOne = false;
                TeleportDestination.DestinationType destinationType = null;
                if (targetType == TargetType.BEACONS) {
                    destinationType = TeleportDestination.DestinationType.BEACON;
                } else if (targetType == TargetType.RAILS) {
                    destinationType = TeleportDestination.DestinationType.RAIL;
                }
                TeleportDestination prevDestination = null;
                TeleportDestination destination = TeleportationHelper.getNextDestination((Entity)player, destinationType, null, null);
                while (destination != null) {
                    if (targetType != TargetType.INVALID || !teleportationHandler.validateDestination((Entity)player, destination)) {
                        this.removeDestination(player, teleportationHandler, destination);
                        foundOne = true;
                    } else {
                        prevDestination = destination;
                    }
                    destination = TeleportationHelper.getNextDestination((Entity)player, destinationType, prevDestination, null);
                }
                if (!foundOne) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none_of_type", new Object[]{targetType}));
                }
            } else {
                TeleportDestination destination = teleportationHandler.getDestinationFromIndex(destinationIndex);
                if (destination == null) {
                    throw new CommandException("command.td.destination.notFound", new Object[]{destinationIndex + 1});
                }
                if (destination.destinationType == TeleportDestination.DestinationType.SPAWNBED && destination.dimension == 0) {
                    throw new CommandException("command.td.delete.spawnBed.invalid", new Object[0]);
                }
                this.removeDestination(player, teleportationHandler, destination);
            }
        }
    }

    private void removeDestination(EntityPlayerMP player, ITeleportationHandler teleportationHandler, TeleportDestination destination) {
        player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.delete.confirmation", new Object[]{TextFormatting.DARK_GREEN + destination.friendlyName + TextFormatting.RESET}));
        if (teleportationHandler.validateDestination((Entity)player, destination)) {
            TeleportationWorks.network.sendTo((IMessage)new PacketUpdateTeleportTileEntity(destination.position, destination.dimension, Boolean.FALSE, null), player);
        }
        teleportationHandler.removeDestination(destination.getUUID());
    }

    public void executeDeleteAllCommand(ICommandSender sender, boolean forceDeleteSpawnBed) throws CommandException {
        EntityPlayerMP player = CommandTeleportation.func_71521_c((ICommandSender)sender);
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            int destinationCount = teleportationHandler.getDestinationCount();
            if (destinationCount == 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none", new Object[0]));
                return;
            }
            teleportationHandler.removeAllDestinations((EntityPlayer)player, forceDeleteSpawnBed);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.deleteAll.confirmation", new Object[0]));
        }
    }

    private void executeNextCommand(ICommandSender sender, int count) throws CommandException {
        EntityPlayerMP player = CommandTeleportation.func_71521_c((ICommandSender)sender);
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            int destinationCount = teleportationHandler.getDestinationCount();
            if (destinationCount == 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none", new Object[0]));
                return;
            }
            TeleportDestination destination = teleportationHandler.getActiveDestination();
            if (count < 0) {
                count = Math.abs(count);
                for (int i = 1; i <= count; ++i) {
                    destination = teleportationHandler.setActiveDestinationToPrevious();
                }
            } else {
                for (int i = 1; i <= count; ++i) {
                    destination = teleportationHandler.setActiveDestinationToNext();
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.active.confirmation", new Object[]{teleportationHandler.getShortFormattedName((EntityPlayer)player, destination)}));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTeleportation.func_71530_a((String[])args, (String[])new String[]{"delete", "list", "next", "prev", "<num>"});
        }
        if (args.length == 2 && !StringUtils.isNumeric((CharSequence)args[0])) {
            if (args[0].equalsIgnoreCase("delete")) {
                if (args[1].isEmpty()) {
                    return Lists.newArrayList((Object[])new String[]{"2", "all", "beacons", "rails", "invalid"});
                }
                return CommandTeleportation.func_71530_a((String[])args, (String[])new String[]{"all", "beacons", "rails", "invalid"});
            }
            if (args[1].isEmpty()) {
                return Lists.newArrayList((Object[])new String[]{"2", "beacons", "rails", "invalid"});
            }
            return CommandTeleportation.func_71530_a((String[])args, (String[])new String[]{"beacons", "rails", "invalid"});
        }
        return Collections.emptyList();
    }

    private static enum TargetType {
        NONE,
        INVALID,
        BEACONS,
        RAILS;

    }
}

