/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.block.teleportbeacon;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.block.ModBlocks;
import org.bensam.tpworks.capability.teleportation.ITeleportationTileEntity;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.network.PacketRequestUpdateTeleportTileEntity;
import org.bensam.tpworks.util.ModUtil;

public class TileEntityTeleportBeacon
extends TileEntity
implements ITeleportationTileEntity,
IWorldNameable,
ITickable {
    public static final long PARTICLE_APPEARANCE_DELAY = 50L;
    public static ItemStack TOPPER_ITEM_WHEN_STORED = null;
    public static Vec3d TELEPORTER_DETECTION_RANGE = new Vec3d(0.5, 0.5, 0.5);
    public static final double PARTICLE_ANGULAR_VELOCITY = 0.3141592653589793;
    public static final double PARTICLE_HORIZONTAL_RADIUS = 0.4;
    public static final double PARTICLE_VERTICAL_POSITIONS = 40.0;
    public static final double PARTICLE_HEIGHT_TO_BEGIN_SCALING = 32.0;
    public static final double PARTICLE_VERTICAL_POSITIONS_PER_BLOCK = 16.0;
    private boolean isSender = false;
    public long blockPlacedTime = 0L;
    public boolean incomingTeleportInProgress = false;
    public long incomingTeleportTimer = 0L;
    public long incomingTeleportTimerStop = 0L;
    protected boolean isStored = false;
    protected double particleSpawnAngle = 0.0;
    private String beaconName = "";
    protected int coolDownTime = 0;
    private UUID uniqueID = new UUID(0L, 0L);
    protected final TeleportationHandler teleportationHandler = new TeleportationHandler();

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.particleSpawnAngle = ModUtil.RANDOM.nextDouble() * Math.PI;
            TeleportationWorks.network.sendToServer((IMessage)new PacketRequestUpdateTeleportTileEntity(this));
        }
    }

    public void func_73660_a() {
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if (this.field_145850_b.field_72995_K) {
            if (this.incomingTeleportInProgress) {
                this.particleSpawnAngle += 0.6283185307179586;
                double blockCenterX = (double)this.field_174879_c.func_177958_n() + 0.5;
                double blockY = (double)this.field_174879_c.func_177956_o() + 0.125;
                double blockCenterZ = (double)this.field_174879_c.func_177952_p() + 0.5;
                double height = (double)this.incomingTeleportTimer % 40.0;
                float scaleModifier = height <= 32.0 ? 1.0f : (100.0f - 8.0f * (float)(height - 32.0)) / 100.0f;
                double yCoord = blockY + height / 16.0;
                for (int i = 0; i < 8; ++i) {
                    double particleISpawnAngle = this.particleSpawnAngle + Math.PI * (double)i / 4.0;
                    double xCoord = blockCenterX + Math.cos(particleISpawnAngle) * 0.5;
                    double zCoord = blockCenterZ + Math.sin(particleISpawnAngle) * 0.5;
                    TeleportationWorks.particles.addTeleportationParticleEffect(this.field_145850_b, xCoord, yCoord, zCoord, scaleModifier);
                }
                ++this.incomingTeleportTimer;
                if (this.incomingTeleportTimer >= this.incomingTeleportTimerStop) {
                    this.incomingTeleportInProgress = false;
                    this.incomingTeleportTimer = 0L;
                    this.incomingTeleportTimerStop = 0L;
                }
            } else if (totalWorldTime >= this.blockPlacedTime + 50L) {
                this.particleSpawnAngle += 0.3141592653589793;
                double blockCenterX = (double)this.field_174879_c.func_177958_n() + 0.5;
                double blockY = (double)this.field_174879_c.func_177956_o() + 0.125;
                double blockCenterZ = (double)this.field_174879_c.func_177952_p() + 0.5;
                double group1Height = (double)totalWorldTime % 40.0;
                float group1ScaleModifier = group1Height <= 32.0 ? 1.0f : (100.0f - 8.0f * (float)(group1Height - 32.0)) / 100.0f;
                double yCoordGroup1 = blockY + group1Height / 16.0;
                double group2Height = (double)(totalWorldTime + 16L) % 40.0;
                float group2ScaleModifier = group2Height <= 32.0 ? 1.0f : (100.0f - 8.0f * (float)(group2Height - 32.0)) / 100.0f;
                double yCoordGroup2 = blockY + group2Height / 16.0;
                double xCoord = blockCenterX + Math.cos(this.particleSpawnAngle) * 0.4;
                double zCoord = blockCenterZ + Math.sin(this.particleSpawnAngle) * 0.4;
                TeleportationWorks.particles.addTeleportationParticleEffect(this.field_145850_b, xCoord, yCoordGroup1, zCoord, group1ScaleModifier);
                TeleportationWorks.particles.addTeleportationParticleEffect(this.field_145850_b, xCoord, yCoordGroup2, zCoord, group2ScaleModifier);
                double particle2SpawnAngle = this.particleSpawnAngle + Math.PI;
                xCoord = blockCenterX + Math.cos(particle2SpawnAngle) * 0.4;
                zCoord = blockCenterZ + Math.sin(particle2SpawnAngle) * 0.4;
                TeleportationWorks.particles.addTeleportationParticleEffect(this.field_145850_b, xCoord, yCoordGroup1, zCoord, group1ScaleModifier);
                TeleportationWorks.particles.addTeleportationParticleEffect(this.field_145850_b, xCoord, yCoordGroup2, zCoord, group2ScaleModifier);
            }
        } else {
            TeleportDestination destination;
            AxisAlignedBB teleporterRangeBB;
            List entitiesInBB;
            if (totalWorldTime % 10L == 0L && this.teleportationHandler.hasActiveDestination() && this.coolDownTime <= 0 && !(entitiesInBB = this.field_145850_b.func_175647_a(Entity.class, teleporterRangeBB = new AxisAlignedBB(this.field_174879_c).func_186664_h(0.1), null)).isEmpty() && this.teleportationHandler.validateDestination(null, destination = this.teleportationHandler.getActiveDestination())) {
                for (Entity entityInBB : entitiesInBB) {
                    if (entityInBB.func_184207_aI() || entityInBB.func_184218_aH()) {
                        TeleportationHelper.teleportEntityAndPassengers(entityInBB, destination);
                        break;
                    }
                    TeleportationHelper.teleport(entityInBB, destination);
                }
            }
            this.coolDownTime = this.coolDownTime > 0 ? --this.coolDownTime : 0;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.beaconName = compound.func_74779_i("beaconName");
            this.uniqueID = compound.func_186857_a("uniqueID");
            this.teleportationHandler.deserializeNBT(compound.func_74775_l("tpHandler"));
            this.isSender = this.teleportationHandler.hasActiveDestination();
            TeleportDestination destination = this.teleportationHandler.getActiveDestination();
            TeleportationWorks.MOD_LOGGER.debug("TileEntityTeleportBeacon.readFromNBT: beaconName = {}, uniqueID = {}, destination = {}", (Object)this.beaconName, (Object)this.uniqueID, destination == null ? "EMPTY" : destination);
        } else {
            TeleportationWorks.MOD_LOGGER.debug("TileEntityTeleportBeacon.readFromNBT: no NBT data to read on client side");
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (!this.beaconName.isEmpty()) {
            compound.func_74778_a("beaconName", this.beaconName);
        }
        compound.func_186854_a("uniqueID", this.uniqueID);
        compound.func_74782_a("tpHandler", (NBTBase)this.teleportationHandler.serializeNBT());
        TeleportDestination destination = this.teleportationHandler.getActiveDestination();
        TeleportationWorks.MOD_LOGGER.debug("TileEntityTeleportBeacon.writeToNBT: beaconName = {}, uniqueID = {}, {}, destination = {}", (Object)this.beaconName, (Object)this.uniqueID, (Object)this.field_174879_c, destination == null ? "EMPTY" : destination);
        return super.func_189515_b(compound);
    }

    @Override
    public boolean isSender() {
        return this.isSender;
    }

    @Override
    public void setSender(boolean isSender) {
        this.isSender = isSender;
    }

    @Override
    public TeleportationHandler getTeleportationHandler() {
        return this.teleportationHandler;
    }

    @Override
    public boolean isStoredByPlayer() {
        return this.isStored;
    }

    @Override
    public void setStoredByPlayer(boolean stored) {
        this.isStored = stored;
    }

    @Override
    public UUID getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public void setDefaultUUID() {
        this.uniqueID = UUID.randomUUID();
        this.func_70296_d();
    }

    @Override
    public String getTeleportName() {
        return this.beaconName;
    }

    @Override
    public void setTeleportName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            this.beaconName = "Beacon " + ModUtil.getRandomLetter() + String.format("%02d", ModUtil.RANDOM.nextInt(100));
            this.func_70296_d();
        } else if (!this.beaconName.equals(name)) {
            this.beaconName = name;
            this.func_70296_d();
        }
    }

    @Override
    public void setIncomingTeleportInProgress() {
        this.incomingTeleportInProgress = true;
        if (this.incomingTeleportTimerStop - this.incomingTeleportTimer < 20L) {
            this.incomingTeleportTimerStop += 40L;
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.getTeleportName() : ModBlocks.TELEPORT_BEACON.func_149739_a();
    }

    public boolean func_145818_k_() {
        return !this.beaconName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void addCoolDownTime(int coolDown) {
        this.coolDownTime += coolDown;
    }

    public int getCoolDownTime() {
        return this.coolDownTime;
    }

    public void setCoolDownTime(int coolDown) {
        this.coolDownTime = coolDown;
    }
}

