/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO = new ImprovedFramebuffer(64, 64, false);
    private int glEmptyTexture;

    public BranchTextureRenderer(Framebuffer defaultFramebuffer) {
        this.glEmptyTexture = this.renderFBO.field_147617_g;
        this.renderFBO.func_147610_a(true);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16384);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.renderFBO.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
    }

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, Framebuffer defaultFramebuffer, boolean justAllocated, ScaledResolution scaledRes) {
        GlStateManager.func_179144_i((int)0);
        this.renderFBO.func_147610_a(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        if (justAllocated) {
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179086_m((int)16384);
        }
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1);
        }
        OpenGLException.checkGLError();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        Minecraft mc = Minecraft.func_71410_x();
        Misc.minecraftOrtho(scaledRes);
        GlStateManager.func_179128_n((int)5888);
        this.renderFBO.func_147609_e();
        mc.func_147110_a().func_147610_a(false);
        GlStateManager.func_179083_b((int)0, (int)0, (int)mc.func_147110_a().field_147621_c, (int)mc.func_147110_a().field_147618_d);
        OpenGLException.checkGLError();
    }

    private void renderCorner(Integer srcTexture, int cornerX, int cornerY) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        GlStateManager.func_179144_i((int)(srcTexture != -1 ? srcTexture : this.glEmptyTexture));
        MapRenderHelper.renderTexturedModalRect(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f);
    }
}

