/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.WorldMap;

public class BlockStateColorTypeCache {
    private Hashtable<IBlockState, Integer> colorTypes = new Hashtable();
    private Hashtable<IBlockState, Integer> overlayColorTypes = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private IBlockState grassState = Blocks.field_150349_c.func_176223_P();
    private IBlockState oakLeavesState = Blocks.field_150362_t.func_176223_P();
    private IBlockState waterState = Blocks.field_150355_j.func_176223_P();

    public void getBlockBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        if (colorType == -1 && isRenderThread) {
            Material material;
            try {
                customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, null, null, 0);
            }
            catch (Throwable t) {
                customColour = 0;
            }
            if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor && (material = state.func_185904_a()) != null && (material.func_151565_r() == MapColor.field_151661_c || material.func_151565_r() == MapColor.field_151669_i)) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
                gotFullCC = true;
                if (material.func_151565_r() == MapColor.field_151661_c && customColour == Minecraft.func_71410_x().func_184125_al().func_186724_a(this.grassState, (IBlockAccess)world, pos, 0)) {
                    customColour = this.grassColor;
                } else if (material.func_151565_r() == MapColor.field_151669_i && customColour == Minecraft.func_71410_x().func_184125_al().func_186724_a(this.oakLeavesState, (IBlockAccess)world, pos, 0)) {
                    customColour = this.foliageColor;
                }
            }
            if (customColour == this.grassColor) {
                colorType = 1;
            } else if (customColour == this.foliageColor) {
                colorType = 2;
            } else {
                if (!gotFullCC) {
                    customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == -1) {
            if (isRenderThread) {
                biomeId = Biome.func_185362_a((Biome)world.func_180494_b(pos));
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            dest[1] = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            dest[1] = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
            }
            dest[2] = customColour;
        }
    }

    public void getOverlayBiomeColour(World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.overlayColorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        if (colorType == -1 && isRenderThread) {
            if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
                colorType = 1;
            } else {
                customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
                gotFullCC = true;
                colorType = 0;
                if (customColour != -1) {
                    Material material = state.func_185904_a();
                    if (material != null && material.func_151565_r() == MapColor.field_151662_n && customColour == Minecraft.func_71410_x().func_184125_al().func_186724_a(this.waterState, (IBlockAccess)world, pos, 0)) {
                        colorType = 1;
                    } else if (customColour != 0xFFFFFF) {
                        colorType = 2;
                    }
                }
            }
            this.overlayColorTypes.put(state, colorType);
        } else if (colorType == 2 && !isRenderThread) {
            colorType = -1;
        }
        dest[0] = colorType;
        if (colorType == 1) {
            if (biomeId == -1) {
                if (!gotFullCC) {
                    customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
                }
                if (customColour == 0xFFFFFF) {
                    dest[0] = 0;
                } else {
                    dest[1] = biomeId = Biome.func_185362_a((Biome)world.func_180494_b(pos));
                }
            }
            dest[1] = biomeId;
        } else if (colorType == 2) {
            if (!gotFullCC) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
            }
            dest[2] = customColour;
        }
    }

    public void updateGrassColor() {
        this.grassColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(this.grassState, null, null, 0);
        this.foliageColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(this.oakLeavesState, null, null, 0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }
}

