/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.dimension.ultraspace.generators;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.worldGeneration.dimension.ultraspace.UltraSpaceBiomeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerBiomeUltraSpace
extends GenLayer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final ChunkGeneratorSettings settings;

    public GenLayerBiomeUltraSpace(long p_i45560_1_, GenLayer p_i45560_3_, WorldType p_i45560_4_, ChunkGeneratorSettings p_i45560_5_) {
        super(p_i45560_1_);
        this.field_75909_a = p_i45560_3_;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd != null) {
                this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
            }
            this.biomes[idx].removeIf(entry -> entry.biome == Biomes.field_76771_b || entry.biome == Biomes.field_150575_M || entry.biome == Biomes.field_76776_l);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76769_d, 30));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_150588_X, 20));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76772_c, 10));
        this.biomes[desertIdx].add(UltraSpaceBiomeRegistry.ultraDesertEntry);
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(Biomes.field_185446_X, 20));
        this.biomes[warmIdx].add(UltraSpaceBiomeRegistry.ultraForestEntry);
        this.biomes[warmIdx].add(UltraSpaceBiomeRegistry.ultraJungleEntry);
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        this.biomes[coolIdx].add(UltraSpaceBiomeRegistry.ultraDeepSeaEntry);
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        this.settings = p_i45560_5_;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.func_75903_a(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                int l = (k & 0xF00) >> 8;
                k &= 0xFFFFF0FF;
                if (this.settings != null && this.settings.field_177779_F >= 0) {
                    aint1[j + i * areaWidth] = this.settings.field_177779_F;
                    continue;
                }
                if (GenLayerBiomeUltraSpace.func_151618_b((int)k)) {
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_76785_t);
                    continue;
                }
                if (k == Biome.func_185362_a((Biome)Biomes.field_76789_p)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == 1) {
                    if (l > 0) {
                        if (this.func_75902_a(3) == 0) {
                            aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_150608_ab);
                            continue;
                        }
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_150607_aa);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT).biome);
                    continue;
                }
                if (k == 2) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_76782_w);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
                    continue;
                }
                if (k == 3) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)Biomes.field_150578_U);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL).biome);
                    continue;
                }
                aint1[j + i * areaWidth] = k == 4 ? Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY).biome) : Biome.func_185362_a((Biome)Biomes.field_76789_p);
            }
        }
        return aint1;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        BiomeManager.BiomeEntry entry;
        do {
            List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
            int totalWeight = WeightedRandom.func_76272_a(biomeList);
            int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
            entry = (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
        } while (entry.biome == Biomes.field_76771_b || entry.biome == Biomes.field_150575_M || entry.biome == Biomes.field_76776_l);
        return entry;
    }
}

