/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.adapters;

import com.google.common.io.Files;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.storage.IStorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class ReforgedFileAdapter
implements IStorageSaveAdapter {
    @Override
    public void save(PokemonStorage storage) {
        NBTTagCompound nbt = storage.writeToNBT(new NBTTagCompound());
        File file = storage.getFile();
        File tempFile = new File(file.getPath() + ".temp");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            tempFile.createNewFile();
            try (DataOutputStream dataStream = new DataOutputStream(new FileOutputStream(tempFile));){
                CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)dataStream);
            }
            if (tempFile.exists()) {
                if (file.exists()) {
                    file.delete();
                }
                tempFile.renameTo(file);
            }
        }
        catch (IOException e) {
            Pixelmon.LOGGER.error("Couldn't write player data file for " + storage.uuid.toString(), (Throwable)e);
        }
    }

    @Override
    public <T extends PokemonStorage> T load(UUID uuid, Class<T> clazz) {
        try {
            PokemonStorage storage = (PokemonStorage)clazz.getConstructor(UUID.class).newInstance(uuid);
            File file = storage.getFile();
            if (file.exists()) {
                try (DataInputStream dataStream = new DataInputStream(new FileInputStream(file));){
                    NBTTagCompound nbt = CompressedStreamTools.func_74794_a((DataInputStream)dataStream);
                    storage.readFromNBT(nbt);
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Couldn't load player data file for " + uuid.toString(), (Throwable)e);
                    try {
                        File backupFile = new File(file.getParentFile(), file.getName() + ".backup");
                        Files.copy((File)file, (File)backupFile);
                    }
                    catch (Exception e2) {
                        Pixelmon.LOGGER.error("Unable to save a backup", (Throwable)e);
                    }
                    storage = (PokemonStorage)clazz.getConstructor(UUID.class).newInstance(uuid);
                }
            } else {
                return (T)storage;
            }
            return (T)storage;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Failed to load storage! " + clazz.getSimpleName() + ", UUID: " + uuid.toString());
            e.printStackTrace();
            return null;
        }
    }
}

