/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.meta;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.Action;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RandomObjective
implements IObjective {
    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return 1;
    }

    @Override
    public String identifier() {
        return "RANDOM";
    }

    @Override
    public Inserter inserter() {
        return Inserter.NONE;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        Dice dice = new Dice();
        for (int i = 1; i < argsIn.length; ++i) {
            String[] split = argsIn[i].split(":");
            int weight = Integer.parseInt(split[0]);
            String[] split2 = split[1].split(",");
            Integer[] actions = new Integer[split2.length];
            for (int j = 0; j < split2.length; ++j) {
                actions[j] = Integer.parseInt(split2[j]);
            }
            dice.addWeight(weight, actions);
        }
        dice.setTotal();
        return new Object[]{dice};
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        Dice dice = (Dice)objectiveArgsIn[0];
        List<Integer> actions = dice.roll();
        for (int action : actions) {
            Action a = stageIn.getParsedActions().get(action);
            a.execute(progressIn.getQuest(), stageIn, dataIn, progressIn);
        }
        return false;
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        return new ArrayList<QuestMarker>();
    }

    private static class Dice {
        private int total;
        private HashMap<Integer, List<Integer>> map = new HashMap();

        private Dice() {
        }

        public void addWeight(int weight, Integer ... actions) {
            this.map.put(weight, Arrays.asList(actions));
        }

        public void setTotal() {
            this.total = 0;
            for (int weight : this.map.keySet()) {
                this.total += weight;
            }
        }

        public List<Integer> roll() {
            int roll = RandomHelper.rand.nextInt(this.total);
            int runningTotal = 0;
            for (Map.Entry<Integer, List<Integer>> entry : this.map.entrySet()) {
                if (entry.getKey() + runningTotal > roll) {
                    return entry.getValue();
                }
                runningTotal += entry.getKey().intValue();
            }
            return new ArrayList<Integer>();
        }
    }
}

