/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.location;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;

public class AbsolutePositionObjective
implements IObjective {
    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return 1;
    }

    @Override
    public String identifier() {
        return "ABSOLUTE_POSITION";
    }

    @Override
    public Inserter inserter() {
        return Inserter.NONE;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        Comparison comparison = new Comparison();
        if (argsIn.length == 6) {
            comparison.ignoreY = true;
            comparison.a = new BlockPos(Integer.parseInt(argsIn[1]), 0, Integer.parseInt(argsIn[2]));
            comparison.b = new BlockPos(Integer.parseInt(argsIn[3]), 0, Integer.parseInt(argsIn[4]));
            comparison.dim = Integer.parseInt(argsIn[5]);
        } else if (argsIn.length == 8) {
            comparison.ignoreY = false;
            comparison.a = new BlockPos(Integer.parseInt(argsIn[1]), Integer.parseInt(argsIn[2]), Integer.parseInt(argsIn[3]));
            comparison.b = new BlockPos(Integer.parseInt(argsIn[4]), Integer.parseInt(argsIn[5]), Integer.parseInt(argsIn[6]));
            comparison.dim = Integer.parseInt(argsIn[7]);
        } else {
            throw new InvalidQuestArgsException();
        }
        return new Object[]{comparison};
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        return ((Comparison)objectiveArgsIn[0]).compare((BlockPos)argsIn[0], (Integer)argsIn[1]);
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        Comparison comparison = (Comparison)objectiveArgsIn[0];
        int dim = (Integer)argsIn[1];
        BlockPos pos = comparison.getMarkerPos();
        if (pos != null && comparison.dim == dim) {
            markers.add(new QuestMarker(pos, dim, progressIn.getQuest().getColor(), progressIn.getMarkerType()));
        }
        return markers;
    }

    class Comparison {
        private int dim = 0;
        private BlockPos a;
        private BlockPos b;
        private boolean ignoreY = false;

        Comparison() {
        }

        public boolean compare(BlockPos pos, int dim) {
            if (this.dim != dim) {
                return false;
            }
            return (this.a.func_177958_n() > this.b.func_177958_n() && pos.func_177958_n() >= this.b.func_177958_n() && pos.func_177958_n() <= this.a.func_177958_n() || this.a.func_177958_n() < this.b.func_177958_n() && pos.func_177958_n() >= this.a.func_177958_n() && pos.func_177958_n() <= this.b.func_177958_n() || this.a.func_177958_n() == pos.func_177958_n() || this.b.func_177958_n() == pos.func_177958_n()) && (this.a.func_177952_p() > this.b.func_177952_p() && pos.func_177952_p() >= this.b.func_177952_p() && pos.func_177952_p() <= this.a.func_177952_p() || this.a.func_177952_p() < this.b.func_177952_p() && pos.func_177952_p() >= this.a.func_177952_p() && pos.func_177952_p() <= this.b.func_177952_p() || this.a.func_177952_p() == pos.func_177952_p() || this.b.func_177952_p() == pos.func_177952_p()) && (this.ignoreY || this.a.func_177956_o() > this.b.func_177956_o() && pos.func_177956_o() >= this.b.func_177956_o() && pos.func_177956_o() <= this.a.func_177956_o() || this.a.func_177956_o() < this.b.func_177956_o() && pos.func_177956_o() >= this.a.func_177956_o() && pos.func_177956_o() <= this.b.func_177956_o() || this.a.func_177956_o() == pos.func_177956_o() || this.b.func_177956_o() == pos.func_177956_o());
        }

        public BlockPos getMarkerPos() {
            if (this.ignoreY) {
                return null;
            }
            return new BlockPos(((double)this.a.func_177958_n() + (double)this.b.func_177958_n()) / 2.0, ((double)this.a.func_177956_o() + (double)this.b.func_177956_o()) / 2.0, ((double)this.a.func_177952_p() + (double)this.b.func_177952_p()) / 2.0);
        }
    }
}

