/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class NPCObjective
implements IObjective {
    private static final String DATA_TAG = "NPC";
    private String identifier;
    private Type type;

    public NPCObjective(String identifier, Type type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return 1;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Inserter inserter() {
        return Inserter.ENTITY;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add((Object)this.type);
        objects.add(argsIn[1]);
        if (this.type == Type.GIVE || this.type == Type.SHOW) {
            String[] newArgs = new String[argsIn.length - 2];
            newArgs[0] = "ITEM_PICKUP";
            System.arraycopy(argsIn, 2, newArgs, 1, argsIn.length - 3);
            objects.add(new Objective(newArgs, questIn, stageIn));
        } else if (this.type == Type.RESPOND) {
            objects.add(argsIn.length == 2 ? 0 : Integer.parseInt(argsIn[2]));
        } else {
            objects.add(null);
        }
        return objects.toArray();
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        Entity npc = (Entity)argsIn[0];
        Type typeIn = (Type)((Object)objectiveArgsIn[0]);
        UUID uuidIn = this.getUUID(objectiveArgsIn, progressIn, stageIn);
        if (uuidIn == null || !npc.getPersistentID().equals(uuidIn)) {
            return false;
        }
        switch (typeIn) {
            case GIVE: 
            case SHOW: {
                Objective objective = (Objective)objectiveArgsIn[2];
                ItemStack stack = (ItemStack)argsIn[1];
                if (!objective.test(stageIn, dataIn, progressIn, stack)) break;
                if (typeIn == Type.GIVE) {
                    stack.func_190918_g((int)this.quantity(objectiveArgsIn));
                }
                return true;
            }
            case RESPOND: {
                if (argsIn[1] != objectiveArgsIn[2]) break;
                return true;
            }
            case TALK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        UUID uuid = this.getUUID(objectiveArgsIn, progressIn, stageIn);
        if (uuid != null) {
            markers.add(new QuestMarker(uuid, 0, progressIn.getQuest().getColor(), progressIn.getMarkerType()));
        }
        return markers;
    }

    public UUID getUUID(Object[] objectiveArgsIn, QuestProgress progressIn, Stage stageIn) {
        String key = DATA_TAG + stageIn.getStage();
        String arg = (String)objectiveArgsIn[1];
        UUID uuidIn = null;
        if (arg.contains("-")) {
            uuidIn = UUID.fromString(arg);
        }
        if (!arg.equalsIgnoreCase("#!") && !arg.equalsIgnoreCase("*")) {
            key = arg;
        }
        if (uuidIn == null) {
            String data = progressIn.getDataString(key);
            if (data == null) {
                return null;
            }
            uuidIn = UUID.fromString(data);
        }
        return uuidIn;
    }

    public static enum Type {
        TALK,
        GIVE,
        SHOW,
        RESPOND;

    }
}

