/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.util.helpers.MapHelper;
import com.pixelmonmod.pixelmon.util.helpers.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class QuestProgressClient {
    private String filename;
    private UUID identifier;
    private QuestColor color;
    private boolean abandonable;
    private boolean repeatable;
    private int weight;
    private boolean radiant;
    private String name;
    private String desc;
    private ArrayList<ObjectiveDetail> objectives;
    private ArrayList<QuestMarker> markers;
    private boolean readyForTurnIn;
    private boolean complete;
    private boolean failed;
    private HashMap<String, Long> dataLongMap;
    private HashMap<String, String> dataStringMap;

    public QuestProgressClient() {
    }

    public QuestProgressClient(ByteBuf buf) {
        this.read(buf);
    }

    public String format(ObjectiveDetail detail) {
        return this.format(detail.getKey(), detail);
    }

    public String format(String key) {
        return this.format(key, null);
    }

    public String format(String key, @Nullable ObjectiveDetail detail) {
        String text;
        if (key == null) {
            key = "";
        }
        String string = text = I18n.func_188566_a((String)key) ? I18n.func_135052_a((String)key, (Object[])new Object[0]) : key;
        if (text.startsWith("quest.") || text.isEmpty()) {
            return "";
        }
        if (detail != null) {
            text = detail.applyPlaceholders(text);
        }
        if (text.contains("?")) {
            for (Map.Entry<String, Long> entry : this.dataLongMap.entrySet()) {
                text = text.replace("?" + entry.getKey() + "?", Long.toString(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : this.dataStringMap.entrySet()) {
                text = text.replace("?" + entry.getKey() + "?", I18n.func_135052_a((String)((String)entry.getValue()), (Object[])new Object[0]));
            }
        }
        return text;
    }

    public String getFilename() {
        return this.filename;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public ArrayList<QuestMarker> getMarkers() {
        return this.markers;
    }

    public QuestColor getColor() {
        return this.color;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isReadyForTurnIn() {
        return this.readyForTurnIn;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getName() {
        String name = this.format(this.name);
        return name == null || name.isEmpty() ? null : name;
    }

    public ArrayList<ObjectiveDetail> getObjectives() {
        return this.objectives;
    }

    public String getDesc() {
        return this.format(this.desc);
    }

    public void update() {
        QuestDataClient.getInstance().update(this.filename, this);
    }

    public void read(ByteBuf buf) {
        int i;
        this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.identifier = UUIDHelper.readUUID(buf);
        if (buf.readBoolean()) {
            this.dataLongMap = MapHelper.readStringLongMapFromByteBuf(buf);
            this.dataStringMap = MapHelper.readStringStringMapFromByteBuf(buf);
            this.color = new QuestColor(buf.readInt());
            this.abandonable = buf.readBoolean();
            this.repeatable = buf.readBoolean();
            this.weight = buf.readInt();
            this.radiant = buf.readBoolean();
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.desc = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.objectives = new ArrayList();
            int sizeA = buf.readInt();
            for (i = 0; i < sizeA; ++i) {
                if (!buf.readBoolean()) continue;
                this.objectives.add(new ObjectiveDetail(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readShort(), buf.readShort(), buf.readBoolean()));
            }
        }
        this.markers = new ArrayList();
        int sizeB = buf.readInt();
        for (i = 0; i < sizeB; ++i) {
            this.markers.add(new QuestMarker(buf));
        }
        this.readyForTurnIn = buf.readBoolean();
        this.complete = buf.readBoolean();
        this.failed = buf.readBoolean();
    }

    public void write(QuestProgress progress, ByteBuf buf) {
        Quest quest = progress.getQuest();
        boolean detail = progress.isComplete() || progress.getStage() >= quest.getActiveStage();
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)quest.getFilename());
        UUIDHelper.writeUUID(progress.getIdentifier(), buf);
        buf.writeBoolean(detail);
        if (detail) {
            MapHelper.writeStringLongMapToByteBuf(buf, progress.getDataLongMap());
            MapHelper.writeStringStringMapToByteBuf(buf, progress.getDataStringMap());
            buf.writeInt(quest.getColor().getRGB());
            buf.writeBoolean(quest.isAbandonable());
            buf.writeBoolean(quest.isRepeatable());
            buf.writeInt(quest.getWeight());
            buf.writeBoolean(quest.isRadiant());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)quest.getUnlocalizedString("name", progress));
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)quest.getUnlocalizedString(progress.isComplete() ? "desc-X" : "desc-" + progress.getStage(), progress));
            Stage stage = progress.getCurrentStage();
            buf.writeInt(progress.isComplete() ? 0 : stage.getParsedObjectives().size());
            int i = 0;
            if (!progress.isComplete()) {
                for (Objective objective : stage.getParsedObjectives()) {
                    String name = quest.getUnlocalizedString("stage-" + stage.getStage() + "-" + i, progress);
                    if (name == null || name.isEmpty()) {
                        buf.writeBoolean(false);
                    } else {
                        buf.writeBoolean(true);
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name);
                        buf.writeShort((int)progress.getObjectiveQuantityComplete(i));
                        buf.writeShort((int)progress.getObjectiveTotalQuantity(i));
                        buf.writeBoolean(progress.isObjectiveComplete(i));
                    }
                    ++i;
                }
            }
        }
        ArrayList<QuestMarker> markers = progress.getMarkers();
        buf.writeInt(markers.size());
        for (QuestMarker marker : markers) {
            marker.write(buf);
        }
        buf.writeBoolean(progress.getNextStage() == null);
        buf.writeBoolean(progress.isComplete());
        buf.writeBoolean(progress.isFailed());
    }
}

