/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import com.pixelmonmod.pixelmon.util.helpers.DimensionHelper;
import net.minecraft.entity.player.EntityPlayerMP;

public class TeleportAction
implements IAction {
    @Override
    public String identifier() {
        return "TELEPORT";
    }

    @Override
    public Object[] parse(Quest quest, Stage stage, String ... args) {
        PositionModifier modifier = new PositionModifier();
        for (String arg : args) {
            if (!arg.contains("=")) continue;
            String[] split = arg.split("=");
            String key = split[0];
            String value = split[1];
            boolean relative = value.contains("~");
            value = value.replace("~", "");
            if (key.equalsIgnoreCase("X")) {
                modifier.x = relative ? Mode.ADD : Mode.SET;
                modifier.pos.x = Double.parseDouble(value);
                continue;
            }
            if (key.equalsIgnoreCase("Y")) {
                modifier.y = relative ? Mode.ADD : Mode.SET;
                modifier.pos.y = Double.parseDouble(value);
                continue;
            }
            if (key.equalsIgnoreCase("Z")) {
                modifier.z = relative ? Mode.ADD : Mode.SET;
                modifier.pos.z = Double.parseDouble(value);
                continue;
            }
            if (key.equalsIgnoreCase("YAW")) {
                modifier.yaw = relative ? Mode.ADD : Mode.SET;
                modifier.rot.yaw = Float.parseFloat(value);
                continue;
            }
            if (key.equalsIgnoreCase("PITCH")) {
                modifier.pitch = relative ? Mode.ADD : Mode.SET;
                modifier.rot.pitch = Float.parseFloat(value);
                continue;
            }
            if (!key.equalsIgnoreCase("DIM")) continue;
            modifier.dim = relative ? Mode.ADD : Mode.SET;
            modifier.dimension = Integer.parseInt(value);
        }
        return new Object[]{modifier};
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Object ... args) {
        ((PositionModifier)args[0]).action(data.getPlayer());
    }

    private class Rot {
        private float yaw = 0.0f;
        private float pitch = 0.0f;

        private Rot() {
        }
    }

    private class Pos {
        private double x = 0.0;
        private double y = 0.0;
        private double z = 0.0;

        private Pos() {
        }
    }

    private class PositionModifier {
        private Mode x = Mode.ADD;
        private Mode y = Mode.ADD;
        private Mode z = Mode.ADD;
        private Mode yaw = Mode.ADD;
        private Mode pitch = Mode.ADD;
        private Mode dim = Mode.ADD;
        private Pos pos = new Pos();
        private Rot rot = new Rot();
        private int dimension = 0;

        private PositionModifier() {
        }

        public void action(EntityPlayerMP player) {
            DimensionHelper.forceTeleport(player, this.dim == Mode.ADD ? player.field_71093_bK + this.dimension : this.dimension, this.x == Mode.ADD ? player.field_70165_t + this.pos.x : this.pos.x, this.y == Mode.ADD ? player.field_70163_u + this.pos.y : this.pos.y, this.z == Mode.ADD ? player.field_70161_v + this.pos.z : this.pos.z, this.yaw == Mode.ADD ? player.field_70177_z + this.rot.yaw : this.rot.yaw, this.pitch == Mode.ADD ? player.field_70125_A + this.rot.pitch : this.rot.pitch);
        }
    }

    private static enum Mode {
        ADD,
        SET;

    }
}

