/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PixelmonLootTables {
    private static final List<String> TABLES = ImmutableList.of((Object)"inject/abandoned_mineshaft", (Object)"inject/desert_pyramid", (Object)"inject/end_city_treasure", (Object)"inject/igloo_chest", (Object)"inject/jungle_temple", (Object)"inject/jungle_temple_dispenser", (Object)"inject/nether_bridge", (Object)"inject/simple_dungeon", (Object)"inject/spawn_bonus_chest", (Object)"inject/stronghold_corridor", (Object)"inject/stronghold_crossing", (Object)"inject/stronghold_library", (Object[])new String[]{"inject/village_blacksmith", "inject/woodland_mansion"});

    public static void register() {
        if (!PixelmonConfig.injectIntoLootTables) {
            return;
        }
        for (String str : TABLES) {
            if (PixelmonConfig.lootIgnoreList.contains(str.split("\\/")[1])) continue;
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("pixelmon", str));
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (!PixelmonConfig.injectIntoLootTables) {
            return;
        }
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file = name.substring(name.indexOf(prefix) + prefix.length());
            if (PixelmonConfig.lootIgnoreList.contains(file)) {
                return;
            }
            switch (file) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "end_city_treasure": 
                case "igloo_chest": 
                case "jungle_temple": 
                case "jungle_temple_dispenser": 
                case "nether_bridge": 
                case "simple_dungeon": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": 
                case "stronghold_crossing": 
                case "stronghold_library": 
                case "village_blacksmith": 
                case "woodland_mansion": {
                    event.getTable().addPool(PixelmonLootTables.getInjectPool(file));
                    break;
                }
            }
        }
    }

    private static LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{PixelmonLootTables.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "pixelmon_inject_pool");
    }

    private static LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("pixelmon", "inject/" + name), weight, 0, new LootCondition[0], "pixelmon_inject_entry");
    }
}

