/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumShellos implements IEnumForm,
ICosmeticForm
{
    East,
    West,
    Gray_Bubbles,
    Gray_Diamonds,
    Purple_Bubbles,
    Purple_Diamonds,
    Violet_Saucy,
    Brown_Stripes,
    Apricot_Saucy,
    Blue_Stripes,
    Moons,
    Sun,
    GoldE,
    GoldW;

    public static Pair<EnumShellos, Integer>[] OLD_ROD_WEIGHTS;

    public static EnumShellos getWeightedRodForm(int rodQuality) {
        int availableForms = 2;
        switch (rodQuality) {
            case 6: {
                availableForms = 14;
                break;
            }
            case 5: {
                availableForms = 12;
                break;
            }
            case 4: {
                availableForms = 10;
                break;
            }
            case 3: {
                availableForms = 8;
                break;
            }
            case 2: {
                availableForms = 6;
                break;
            }
            case 1: {
                availableForms = 4;
            }
        }
        double totalWeight = 0.0;
        for (int i = 0; i < availableForms; ++i) {
            totalWeight += (double)((Integer)OLD_ROD_WEIGHTS[i].getRight()).intValue();
        }
        int randomIndex = -1;
        double random = Math.random() * totalWeight;
        for (int i = 0; i < OLD_ROD_WEIGHTS.length; ++i) {
            if (!((random -= (double)((Integer)OLD_ROD_WEIGHTS[i].getRight()).intValue()) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return (EnumShellos)OLD_ROD_WEIGHTS[randomIndex].getLeft();
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == East || this == West;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.shellos.form." + this.name().toLowerCase();
    }

    public static EnumShellos getFromIndex(int index) {
        try {
            return EnumShellos.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return East;
        }
    }

    @Override
    public String getFormSuffix(boolean shiny) {
        if (shiny) {
            return "-" + (this.ordinal() % 2 == 0 ? East.name().toLowerCase() : West.name().toLowerCase());
        }
        return this.getFormSuffix();
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this != East && this != West;
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        return this.ordinal() % 2 == 0 ? East : West;
    }

    static {
        OLD_ROD_WEIGHTS = new Pair[]{ImmutablePair.of((Object)East, (Object)120), ImmutablePair.of((Object)West, (Object)120), ImmutablePair.of((Object)Gray_Bubbles, (Object)60), ImmutablePair.of((Object)Purple_Bubbles, (Object)60), ImmutablePair.of((Object)Gray_Diamonds, (Object)60), ImmutablePair.of((Object)Purple_Diamonds, (Object)60), ImmutablePair.of((Object)Violet_Saucy, (Object)40), ImmutablePair.of((Object)Apricot_Saucy, (Object)40), ImmutablePair.of((Object)Brown_Stripes, (Object)40), ImmutablePair.of((Object)Blue_Stripes, (Object)40), ImmutablePair.of((Object)Moons, (Object)20), ImmutablePair.of((Object)Sun, (Object)20), ImmutablePair.of((Object)GoldE, (Object)5), ImmutablePair.of((Object)GoldW, (Object)5)};
    }
}

