/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;

public enum EnumDarmanitan implements IEnumForm
{
    STANDARD,
    ZEN,
    GALAR_STANDARD,
    GALAR_ZEN;


    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase().replace("_", "-");
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == STANDARD || this == GALAR_STANDARD;
    }

    @Override
    public boolean isTemporary() {
        return this == ZEN || this == GALAR_ZEN;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        if (pokemon.getFormEnum() == ZEN) {
            return STANDARD;
        }
        if (pokemon.getFormEnum() == GALAR_ZEN) {
            return GALAR_STANDARD;
        }
        return STANDARD;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.darmanitan.form." + this.name().toLowerCase();
    }

    public EnumDarmanitan getZenFromStandard() {
        return this == GALAR_STANDARD ? GALAR_ZEN : ZEN;
    }
}

