/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.pixelmonmod.pixelmon.api.pokemon.EnumInitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Type1Spec
extends SpecValue<String>
implements ISpecType {
    private String value;
    private List<String> keys;

    public Type1Spec(List<String> keys, String value) {
        super(keys.get(0), value);
        this.keys = keys;
        this.value = value;
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    public Type1Spec parse(@Nullable String s) {
        return new Type1Spec(this.keys, s);
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbtTagCompound) {
        return this.parse(nbtTagCompound.func_74779_i(this.key));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, SpecValue<?> specValue) {
        nbtTagCompound.func_74778_a(this.key, this.value);
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return this.getClass();
    }

    @Override
    public String toParameterForm(SpecValue<?> specValue) {
        return this.key + ":" + this.value;
    }

    @Override
    public Class<String> getValueClass() {
        return String.class;
    }

    @Override
    public void apply(EntityPixelmon entityPixelmon) {
        this.apply(entityPixelmon.getPokemonData());
    }

    @Override
    public void apply(NBTTagCompound nbtTagCompound) {
    }

    @Override
    public void apply(Pokemon pokemon) {
        PokemonSpec spec = PokemonSpec.from(this.randomPokeType(this.value).getPokemonName());
        spec.apply(pokemon);
        pokemon.initialize(EnumInitializeCategory.INTRINSIC_FORCEFUL);
    }

    @Override
    public boolean matches(EntityPixelmon entityPixelmon) {
        return entityPixelmon.getPokemonData().getBaseStats().getType1().func_176610_l().equalsIgnoreCase(this.value);
    }

    @Override
    public boolean matches(NBTTagCompound nbtTagCompound) {
        return false;
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return pokemon.getBaseStats().getType1().func_176610_l().equalsIgnoreCase(this.value);
    }

    @Override
    public SpecValue<String> clone() {
        return new Type1Spec(this.keys, this.value);
    }

    private EnumSpecies randomPokeType(String value) {
        EnumSpecies s = EnumSpecies.randomPoke();
        boolean isValid = false;
        while (!isValid) {
            if (!s.getBaseStats().getType1().func_176610_l().equalsIgnoreCase(value)) {
                s = EnumSpecies.randomPoke();
                continue;
            }
            isValid = true;
        }
        return s;
    }

    private EnumSpecies randomPokeTypeLeg(String value) {
        EnumSpecies s = EnumSpecies.randomPoke();
        boolean isValid = false;
        while (!isValid) {
            if (!s.getBaseStats().getType1().func_176610_l().equalsIgnoreCase(value) && !EnumSpecies.legendaries.contains(s.getPokemonName())) {
                s = EnumSpecies.randomPoke();
                continue;
            }
            isValid = true;
        }
        return s;
    }
}

