/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class GenerationSpec
extends SpecValue<Integer>
implements ISpecType {
    public static HashMap<Integer, ArrayList<EnumSpecies>> generationLists = null;

    static void initializeGenerationList() {
        generationLists = new HashMap();
        for (EnumSpecies species : EnumSpecies.values()) {
            int generation = species.getGeneration();
            if (!generationLists.containsKey(generation)) {
                generationLists.put(generation, Lists.newArrayList((Object[])new EnumSpecies[]{species}));
                continue;
            }
            generationLists.get(generation).add(species);
        }
    }

    public GenerationSpec(Integer value) {
        super("generation", value);
        if (generationLists == null) {
            GenerationSpec.initializeGenerationList();
        }
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"gen", "generation"});
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        if (arg == null) {
            return null;
        }
        try {
            return new GenerationSpec(Integer.parseInt(arg));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return this.parse(nbt.func_74762_e(this.key) + "");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74778_a(this.key, value.value.toString());
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return GenerationSpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return "generation:" + value.value.toString();
    }

    @Override
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        this.apply(pixelmon.getPokemonData());
    }

    @Override
    public void apply(Pokemon pokemon) {
        EnumSpecies randomSpecies = (EnumSpecies)CollectionHelper.getRandomElement(generationLists.getOrDefault(this.value, new ArrayList()));
        if (randomSpecies != null) {
            pokemon.setSpecies(randomSpecies, true);
        }
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return pokemon.getSpecies().getGeneration() == ((Integer)this.value).intValue();
    }

    @Override
    public SpecValue<Integer> clone() {
        return new GenerationSpec((Integer)this.value);
    }
}

