/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;

public abstract class IgnoreWeather
extends AbilityBase {
    private String switchInMessage;

    public IgnoreWeather(String switchInMessage) {
        this.switchInMessage = switchInMessage;
    }

    @Override
    public boolean ignoreWeather() {
        return true;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.globalStatusController.canWeatherChange(null)) {
            newPokemon.bc.sendToAll(this.switchInMessage, newPokemon.getNickname());
            newPokemon.bc.globalStatusController.triggerWeatherChange(null);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        for (PixelmonWrapper pw : oldPokemon.bc.getActiveUnfaintedPokemon()) {
            if (pw == oldPokemon || !pw.getBattleAbility().ignoreWeather()) continue;
            return;
        }
        if (oldPokemon.bc.globalStatusController.canWeatherChange(oldPokemon.bc.globalStatusController.getWeather())) {
            oldPokemon.bc.globalStatusController.triggerWeatherChange(oldPokemon.bc.globalStatusController.getWeather());
        }
    }
}

