/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.MysteriousAirCurrent;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;

public class DeltaStream
extends AbilityBase {
    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (!(newPokemon.bc.globalStatusController.getWeatherIgnoreAbility() instanceof MysteriousAirCurrent)) {
            newPokemon.bc.globalStatusController.addGlobalStatus(new MysteriousAirCurrent());
            newPokemon.bc.sendToAll("pixelmon.effect.mysteriousaircurrent", newPokemon.getNickname());
        }
    }

    private void checkForRemoval(PixelmonWrapper pokemon) {
        if (pokemon.bc.globalStatusController.getWeatherIgnoreAbility() instanceof MysteriousAirCurrent) {
            for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
                if (pw == pokemon || !(pw.getBattleAbility() instanceof DeltaStream)) continue;
                return;
            }
            pokemon.bc.globalStatusController.removeGlobalStatus(StatusType.MysteriousAirCurrent);
            pokemon.bc.globalStatusController.triggerWeatherChange(null);
            pokemon.bc.sendToAll("pixelmon.effect.mysteriousaircurrentfaded", new Object[0]);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.checkForRemoval(oldPokemon);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.checkForRemoval(pokemon);
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (pokemon.isFainted()) {
            this.checkForRemoval(pokemon);
        }
    }
}

