/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.GuardSplit;
import com.pixelmonmod.pixelmon.battles.status.PowerSplit;
import com.pixelmonmod.pixelmon.battles.status.PowerTrick;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.WonderRoom;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;

public class BeastBoost
extends AbilityBase {
    @Override
    public void onAllyFaint(PixelmonWrapper pokemon, PixelmonWrapper fainted, PixelmonWrapper source) {
        if (source == pokemon) {
            this.beastBoost(pokemon);
        }
    }

    @Override
    public void onFoeFaint(PixelmonWrapper pokemon, PixelmonWrapper fainted, PixelmonWrapper source) {
        if (source == pokemon) {
            this.beastBoost(pokemon);
        }
    }

    private void beastBoost(PixelmonWrapper pokemon) {
        StatsType highest = StatsType.HP;
        int highestAmount = 0;
        int[] stats = pokemon.getBattleStats().getBaseBattleStats();
        for (StatusBase statusBase : pokemon.getStatuses()) {
            if (!(statusBase instanceof PowerSplit) && !(statusBase instanceof GuardSplit) && !(statusBase instanceof PowerTrick)) continue;
            stats = statusBase.modifyStats(pokemon, stats);
        }
        for (GlobalStatusBase globalStatusBase : pokemon.bc.globalStatusController.getGlobalStatuses()) {
            if (!(globalStatusBase instanceof WonderRoom)) continue;
            globalStatusBase.modifyBaseStats(pokemon, stats);
        }
        if (stats[StatsType.Attack.getStatIndex()] > highestAmount) {
            highestAmount = stats[StatsType.Attack.getStatIndex()];
            highest = StatsType.Attack;
        }
        if (stats[StatsType.Defence.getStatIndex()] > highestAmount) {
            highestAmount = stats[StatsType.Defence.getStatIndex()];
            highest = StatsType.Defence;
        }
        if (stats[StatsType.SpecialAttack.getStatIndex()] > highestAmount) {
            highestAmount = stats[StatsType.SpecialAttack.getStatIndex()];
            highest = StatsType.SpecialAttack;
        }
        if (stats[StatsType.SpecialDefence.getStatIndex()] > highestAmount) {
            highestAmount = stats[StatsType.SpecialDefence.getStatIndex()];
            highest = StatsType.SpecialDefence;
        }
        if (stats[StatsType.Speed.getStatIndex()] > highestAmount) {
            highest = StatsType.Speed;
        }
        if (pokemon.getBattleStats().statCanBeRaised(highest)) {
            pokemon.getBattleStats().modifyStat(1, highest);
        }
    }
}

