/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands.econ;

import com.mojang.authlib.GameProfile;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class GiveMoneyCommand
extends PixelmonCommand {
    public GiveMoneyCommand() {
        super("givemoney", "/givemoney <player> <money>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2) {
            this.resendWithMultipleTargets(sender, args, 0);
            GameProfile target = GiveMoneyCommand.findProfile(args[0]);
            if (target == null) {
                GiveMoneyCommand.endCommand("commands.generic.player.notFound", args[0]);
            }
            int amount = GiveMoneyCommand.requireInt(args[1], -999999, 999999, "commands.generic.num.invalid", new Object[0]);
            IPixelmonBankAccount targetAccount = (IPixelmonBankAccount)((Object)GiveMoneyCommand.require(Pixelmon.moneyManager.getBankAccount(target.getId()), "pixelmon.command.general.invalidplayer", new Object[0]));
            int beforeCurrency = targetAccount.getMoney();
            int currencyDifference = targetAccount.changeMoney(amount) - beforeCurrency;
            if (currencyDifference == 0) {
                if (amount > 0) {
                    this.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", target.getName());
                } else {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.givemoney.nomoney", target.getName());
                }
            } else {
                String currencyString = Integer.toString(currencyDifference);
                GiveMoneyCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.givemoney.notifygive", (Object[])new Object[]{sender.func_70005_c_(), currencyDifference, target.getName()});
                this.sendMessage(sender, "pixelmon.command.givemoney.given", currencyString, target.getName());
                EntityPlayerMP player = GiveMoneyCommand.getEntityPlayer(target.getId());
                if (player != null && player != sender) {
                    this.sendMessage((ICommandSender)player, TextFormatting.GRAY, "pixelmon.command.givemoney.received", sender.func_145748_c_(), currencyString);
                }
            }
        } else if (args.length == 1) {
            this.execute(sender, new String[]{sender.func_70005_c_(), args[0]});
        } else {
            sender.func_145747_a(GiveMoneyCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            GiveMoneyCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length != 1 ? GiveMoneyCommand.tabComplete(args, new String[0]) : GiveMoneyCommand.tabCompleteUsernames(args);
    }
}

