/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumStoreTrainerDataType;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StoreTrainerData
implements IMessage {
    int trainerId;
    SetTrainerData data;
    ItemStack[] drops;
    EnumStoreTrainerDataType dataType;

    public StoreTrainerData() {
    }

    public StoreTrainerData(int trainerId, SetTrainerData data) {
        this.trainerId = trainerId;
        this.data = data;
        this.dataType = EnumStoreTrainerDataType.CHAT;
    }

    public StoreTrainerData(int currentTrainerID, ItemStack[] drops) {
        this.trainerId = currentTrainerID;
        this.drops = drops;
        this.dataType = EnumStoreTrainerDataType.DROPS;
    }

    public void fromBytes(ByteBuf buf) {
        this.trainerId = buf.readInt();
        this.dataType = EnumStoreTrainerDataType.values()[buf.readInt()];
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            this.data = new SetTrainerData();
            this.data.decodeInto(buf);
        } else {
            this.drops = new ItemStack[buf.readInt()];
            for (int i = 0; i < this.drops.length; ++i) {
                this.drops[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.trainerId);
        buf.writeInt(this.dataType.ordinal());
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            this.data.encodeInto(buf);
        } else {
            buf.writeInt(this.drops.length);
            for (ItemStack stack : this.drops) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<StoreTrainerData, IMessage> {
        public IMessage onMessage(StoreTrainerData message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!ItemNPCEditor.checkPermission((EntityPlayer)player)) {
                return null;
            }
            Optional<NPCTrainer> entityNPCOptional = EntityNPC.locateNPCServer(player.field_70170_p, message.trainerId, NPCTrainer.class);
            if (!entityNPCOptional.isPresent()) {
                return null;
            }
            NPCTrainer trainer = entityNPCOptional.get();
            if (message.dataType == EnumStoreTrainerDataType.CHAT) {
                trainer.update(message.data);
            } else {
                trainer.updateDrops(message.drops);
            }
            return null;
        }
    }
}

