/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NPCLearnMove
implements IMessage {
    UUID pokemonUUID;
    EnumNPCType npcType;

    public NPCLearnMove() {
    }

    public NPCLearnMove(UUID pokemonUUID, EnumNPCType npcType) {
        this.pokemonUUID = pokemonUUID;
        this.npcType = npcType;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = new UUID(buf.readLong(), buf.readLong());
        this.npcType = EnumNPCType.getFromOrdinal(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.pokemonUUID);
        buf.writeInt(this.npcType.ordinal());
    }

    public static class Handler
    implements ISyncHandler<NPCLearnMove> {
        @Override
        public void onSyncMessage(NPCLearnMove message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            Pokemon pokemon = party.find(message.pokemonUUID);
            if (pokemon != null) {
                if (message.npcType == EnumNPCType.Relearner) {
                    OpenScreen.open((EntityPlayer)player, EnumGuiScreen.Relearner, pokemon.getPosition().order);
                } else if (message.npcType == EnumNPCType.Tutor) {
                    OpenScreen.open((EntityPlayer)player, EnumGuiScreen.Tutor, pokemon.getPosition().order);
                }
            }
        }
    }
}

