/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChooseMoveset
implements IMessage {
    public static final ArrayList<ChoosingMovesetData> choosingMoveset = new ArrayList(4);
    UUID uuid;
    ArrayList<Integer> attackIds = new ArrayList(600);

    public ChooseMoveset() {
    }

    public ChooseMoveset(Pokemon pokemon, ArrayList<Attack> chosenAttackList) {
        this.uuid = pokemon.getUUID();
        this.attackIds.addAll(chosenAttackList.stream().map(a -> a.getActualMove().getAttackId()).collect(Collectors.toList()));
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        int num = buf.readShort();
        for (int i = 0; i < num; ++i) {
            this.attackIds.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.uuid);
        buf.writeShort(this.attackIds.size());
        this.attackIds.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
    }

    public static class Handler
    implements ISyncHandler<ChooseMoveset> {
        @Override
        public void onSyncMessage(ChooseMoveset message, MessageContext ctx) {
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(ctx.getServerHandler().field_147369_b);
            Pokemon pokemon = party.find(message.uuid);
            pokemon.getMoveset().replaceWith(message.attackIds);
            ChoosingMovesetData d = CollectionHelper.find(choosingMoveset, c -> c.player.getPersistentID() == ctx.getServerHandler().field_147369_b.getPersistentID());
            if (d != null) {
                d.next();
                if (d.pokemonList.isEmpty()) {
                    choosingMoveset.remove(d);
                }
            }
        }
    }
}

