/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DynamaxUpdate
implements IMessage {
    UUID pokemonUUID;
    float scale;

    public DynamaxUpdate() {
    }

    public DynamaxUpdate(UUID pokemonUUID, float scale) {
        this.pokemonUUID = pokemonUUID;
        this.scale = scale;
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.pokemonUUID);
        buf.writeFloat(this.scale);
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = new UUID(buf.readLong(), buf.readLong());
        this.scale = buf.readFloat();
    }

    public static class Handler
    implements IMessageHandler<DynamaxUpdate, IMessage> {
        public IMessage onMessage(DynamaxUpdate message, MessageContext ctx) {
            EntityPixelmon pixelmon = ClientProxy.battleManager.getEntity(message.pokemonUUID);
            if (pixelmon != null) {
                float scale = pixelmon.dynamaxScale + message.scale;
                if (scale < 1.0f) {
                    scale = 1.0f;
                }
                if (scale > PixelmonConfig.dynamaxScale) {
                    scale = PixelmonConfig.dynamaxScale;
                }
                pixelmon.dynamaxScale = scale;
            }
            return null;
        }
    }
}

