/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChooseAttack
implements IMessage {
    public int buttonId;
    public boolean[][] targetting;
    public int battleIndex;
    public UUID pokemonUUID;
    public boolean megaEvolving;
    public boolean dynamaxing;

    public ChooseAttack() {
    }

    public ChooseAttack(UUID pokemonUUID, boolean[][] targetting, int buttonId, int battleIndex, boolean megaEvolving, boolean dynamaxing) {
        this.pokemonUUID = pokemonUUID;
        this.buttonId = buttonId;
        this.battleIndex = battleIndex;
        this.targetting = targetting;
        this.megaEvolving = megaEvolving;
        this.dynamaxing = dynamaxing;
    }

    public void fromBytes(ByteBuf buffer) {
        int i;
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.buttonId = buffer.readInt();
        this.battleIndex = buffer.readInt();
        this.targetting = new boolean[buffer.readShort()][];
        for (i = 0; i < this.targetting.length; ++i) {
            this.targetting[i] = new boolean[buffer.readShort()];
        }
        for (i = 0; i < this.targetting.length; ++i) {
            for (int j = 0; j < this.targetting[i].length; ++j) {
                this.targetting[i][j] = buffer.readBoolean();
            }
        }
        this.megaEvolving = buffer.readBoolean();
        this.dynamaxing = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        PixelmonMethods.toBytesUUID(buffer, this.pokemonUUID);
        buffer.writeInt(this.buttonId);
        buffer.writeInt(this.battleIndex);
        buffer.writeShort(this.targetting.length);
        for (boolean[] aTargetting1 : this.targetting) {
            buffer.writeShort(aTargetting1.length);
        }
        for (boolean[] aTargetting : this.targetting) {
            for (int j = 0; j < aTargetting.length; ++j) {
                buffer.writeBoolean(aTargetting[j]);
            }
        }
        buffer.writeBoolean(this.megaEvolving);
        buffer.writeBoolean(this.dynamaxing);
    }

    public static class Handler
    implements IMessageHandler<ChooseAttack, IMessage> {
        public IMessage onMessage(ChooseAttack message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_143004_u();
            BattleControllerBase bc = BattleRegistry.getBattle(message.battleIndex);
            if (bc == null) {
                return null;
            }
            PixelmonWrapper pw = bc.getPokemonFromUUID(message.pokemonUUID);
            if (pw != null) {
                BattleParticipant p = pw.getParticipant();
                if (message.buttonId == -1) {
                    pw.chooseMove(p.getBattleAI().getNextMove(pw));
                } else {
                    if (message.buttonId < 4 && (message.megaEvolving || message.dynamaxing)) {
                        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(ctx.getServerHandler().field_147369_b);
                        if (!storage.getMegaItem().canEvolve() && pw.getSpecies() != EnumSpecies.Rayquaza) {
                            message.megaEvolving = false;
                        }
                        if (!storage.getMegaItem().canDynamax()) {
                            message.dynamaxing = false;
                        }
                    } else {
                        message.megaEvolving = false;
                        message.dynamaxing = false;
                    }
                    ArrayList<PixelmonWrapper> targets = this.findTargets(message, bc, p);
                    pw.setAttack(message.buttonId, targets, message.megaEvolving || message.dynamaxing);
                }
            }
            return null;
        }

        private ArrayList<PixelmonWrapper> findTargets(ChooseAttack message, BattleControllerBase bc, BattleParticipant p) {
            ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
            ArrayList<PixelmonWrapper> teamPokemon = bc.getTeamPokemon(p);
            for (int i = 0; i < message.targetting[0].length; ++i) {
                if (!message.targetting[0][i] || i >= teamPokemon.size()) continue;
                targets.add(teamPokemon.get(i));
            }
            ArrayList<PixelmonWrapper> opponentPokemon = bc.getOpponentPokemon(p);
            for (int i = 0; i < message.targetting[1].length; ++i) {
                if (!message.targetting[1][i]) continue;
                if (i < opponentPokemon.size()) {
                    targets.add(opponentPokemon.get(i));
                    continue;
                }
                PixelmonWrapper fallback = opponentPokemon.get(opponentPokemon.size() - 1);
                if (targets.contains(fallback)) break;
                targets.add(fallback);
                break;
            }
            return targets;
        }
    }
}

