/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PixelExtrasDisplayPacket
implements IMessage {
    private UUID uuid;
    public int dataHash;
    private final EnumSet<PixelExtrasData.Category> enabled = EnumSet.noneOf(PixelExtrasData.Category.class);
    private PixelExtrasData.HatType hatType = PixelExtrasData.HatType.NONE;
    private PixelExtrasData.MonocleType monocleType = PixelExtrasData.MonocleType.NONE;
    private PixelExtrasData.SashType sashType = PixelExtrasData.SashType.NONE;
    private PixelExtrasData.RobeType robeType = PixelExtrasData.RobeType.NONE;
    private PixelExtrasData.SphealType sphealType = PixelExtrasData.SphealType.DEFAULT;
    private int[][] colours = new int[3][3];

    public PixelExtrasDisplayPacket() {
    }

    public PixelExtrasDisplayPacket(PixelExtrasData data) {
        this.uuid = data.id;
        this.dataHash = data.dataHash();
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            if (!data.isEnabled(category)) continue;
            this.enabled.add(category);
        }
        this.hatType = data.getHatType();
        this.monocleType = data.getMonocleType();
        this.sashType = data.getSashType();
        this.robeType = data.getRobeType();
        this.sphealType = data.getSphealType();
        this.colours[0] = data.getColours(PixelExtrasData.Category.SASH);
        this.colours[1] = data.getColours(PixelExtrasData.Category.HAT);
        this.colours[2] = data.getColours(PixelExtrasData.Category.MONOCLE);
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.dataHash = buf.readInt();
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            if (!buf.readBoolean()) continue;
            this.enabled.add(category);
        }
        this.hatType = PixelExtrasData.HatType.getFromId(buf.readByte());
        this.monocleType = PixelExtrasData.MonocleType.getFromId(buf.readByte());
        this.sashType = PixelExtrasData.SashType.values()[buf.readByte()];
        this.robeType = PixelExtrasData.RobeType.values()[buf.readByte()];
        this.sphealType = PixelExtrasData.SphealType.values()[buf.readByte()];
        for (int i = 0; i < this.colours.length; ++i) {
            for (int b = 0; b < 3; ++b) {
                this.colours[i][b] = buf.readInt();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits()).writeLong(this.uuid.getLeastSignificantBits());
        buf.writeInt(this.dataHash);
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            buf.writeBoolean(this.enabled.contains((Object)category));
        }
        buf.writeByte(this.hatType.id);
        buf.writeByte(this.monocleType.id);
        buf.writeByte(this.sashType.ordinal());
        buf.writeByte(this.robeType.ordinal());
        buf.writeByte(this.sphealType.ordinal());
        for (int i = 0; i < this.colours.length; ++i) {
            for (int b = 0; b < 3; ++b) {
                buf.writeInt(this.colours[i][b]);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PixelExtrasDisplayPacket, IMessage> {
        public IMessage onMessage(PixelExtrasDisplayPacket message, MessageContext ctx) {
            Consumer<PixelExtrasData> consumer = data -> {
                for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
                    data.setEnabled(category, message.enabled.contains((Object)category));
                }
                data.setHatType(message.hatType);
                data.setMonocleType(message.monocleType);
                data.setSashType(message.sashType);
                data.setRobeType(message.robeType);
                data.setSphealType(message.sphealType);
                data.setColours(PixelExtrasData.Category.SASH, message.colours[0]);
                data.setColours(PixelExtrasData.Category.HAT, message.colours[1]);
                data.setColours(PixelExtrasData.Category.MONOCLE, message.colours[2]);
            };
            if (ctx.side == Side.CLIENT) {
                PixelExtrasData data2 = new PixelExtrasData(message.uuid);
                ExtrasContact.updateData(data2, message.dataHash, consumer.andThen(PlayerExtraDataStore::add));
            } else {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                PixelExtrasData data3 = PixelExtrasStorage.getData(player.func_110124_au());
                if (data3.isReady() && ExtrasContact.checkCacheHash(message.uuid, message.dataHash)) {
                    consumer.accept(data3);
                    if (data3.hasData()) {
                        Pixelmon.network.sendToAll((IMessage)new PixelExtrasDisplayPacket(data3));
                    }
                } else {
                    ExtrasContact.updateData(data3, message.dataHash, consumer.andThen(PixelExtrasStorage::addAndDistribute));
                }
            }
            return null;
        }
    }
}

