/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientUpdatePokedex
implements IMessage {
    private Map<Integer, EnumPokedexRegisterStatus> data;
    private Table<Integer, Short, Short> data2;

    public ClientUpdatePokedex() {
    }

    public ClientUpdatePokedex(Pokedex p) {
        this.data = p.getSeenMap();
        this.data2 = p.formDex;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.data.size());
        for (Map.Entry<Integer, EnumPokedexRegisterStatus> pair : this.data.entrySet()) {
            buffer.writeInt(pair.getKey().intValue());
            buffer.writeShort(pair.getValue().ordinal());
        }
        buffer.writeInt(this.data2.cellSet().size());
        this.data2.cellSet().forEach(cell -> {
            buffer.writeInt(((Integer)cell.getRowKey()).intValue());
            buffer.writeShort((int)((Short)cell.getColumnKey()).shortValue());
            buffer.writeShort((int)((Short)cell.getValue()).shortValue());
        });
    }

    public void fromBytes(ByteBuf buffer) {
        this.data = new HashMap<Integer, EnumPokedexRegisterStatus>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.data.put(buffer.readInt(), EnumPokedexRegisterStatus.get(buffer.readShort()));
        }
        this.data2 = HashBasedTable.create();
        int size2 = buffer.readInt();
        for (int i = 0; i < size2; ++i) {
            this.data2.put((Object)buffer.readInt(), (Object)buffer.readShort(), (Object)buffer.readShort());
        }
    }

    public static class Handler
    implements ISyncHandler<ClientUpdatePokedex> {
        @Override
        public void onSyncMessage(ClientUpdatePokedex message, MessageContext ctx) {
            ClientStorageManager.pokedex.update(message.data, (Table<Integer, Short, Short>)message.data2);
        }
    }
}

