/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.models.smd.AnimFrame;
import com.pixelmonmod.pixelmon.client.models.smd.Bone;
import com.pixelmonmod.pixelmon.client.models.smd.GabeNewellException;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.helpers.VectorHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Matrix4f;

public class SmdAnimation {
    public final ValveStudioModel owner;
    public ArrayList<AnimFrame> frames = new ArrayList();
    public ArrayList<Bone> bones = new ArrayList();
    public int currentFrameIndex = 0;
    public int lastFrameIndex;
    public int totalFrames;
    public String animationName;
    private int frameIDBank = 0;

    public SmdAnimation(ValveStudioModel owner, String animationName, ResourceLocation resloc) throws GabeNewellException {
        this.owner = owner;
        this.animationName = animationName;
        if (resloc.func_110623_a().endsWith(".bmd")) {
            this.loadBmdModel(resloc);
        } else {
            this.loadSmdAnim(resloc);
        }
        this.setBoneChildren();
        this.reform();
    }

    public SmdAnimation(SmdAnimation anim, ValveStudioModel owner) {
        this.owner = owner;
        this.animationName = anim.animationName;
        for (Bone b : anim.bones) {
            this.bones.add(new Bone(b, b.parent != null ? this.bones.get(b.parent.ID) : null, null));
        }
        this.frames.addAll(anim.frames.stream().map(f -> new AnimFrame((AnimFrame)f, this)).collect(Collectors.toList()));
        this.totalFrames = anim.totalFrames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSmdAnim(ResourceLocation resloc) throws GabeNewellException {
        BufferedInputStream inputStream = Pixelmon.proxy.getStreamForResourceLocation(resloc);
        String currentLine = null;
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            block11: while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                if (currentLine.startsWith("version")) continue;
                if (currentLine.startsWith("nodes")) {
                    ++lineCount;
                    while (true) {
                        if ((currentLine = reader.readLine()).startsWith("end")) continue block11;
                        this.parseBone(currentLine, ++lineCount);
                    }
                }
                if (!currentLine.startsWith("skeleton")) continue;
                this.startParsingAnimation(reader, lineCount, resloc);
            }
            return;
        }
        catch (IOException e) {
            if (lineCount != -1) throw new GabeNewellException("an error occurred reading the SMD file \"" + resloc + "\" on line #" + lineCount, e);
            throw new GabeNewellException("there was a problem opening the model file : " + resloc, e);
        }
    }

    private void loadBmdModel(ResourceLocation modelLoc) throws GabeNewellException {
        BufferedInputStream inputStream = Pixelmon.proxy.getStreamForResourceLocation(modelLoc);
        try (DataInputStream in = new DataInputStream(inputStream);){
            byte version = in.readByte();
            assert (version == 1);
            int numNodes = in.readShort();
            CommonHelper.ensureIndex(this.bones, numNodes - 1);
            for (int i = 0; i < numNodes; ++i) {
                short boneID = in.readShort();
                short parentBone = in.readShort();
                String name = SmdAnimation.readNullTerm(in);
                Bone parent = parentBone != -1 ? this.bones.get(parentBone) : null;
                this.bones.set(boneID, new Bone(name, boneID, parent, null));
            }
            LinkedHashMap skeletonMap = new LinkedHashMap();
            short s = in.readShort();
            this.totalFrames = s;
            short numSkeletons = s;
            for (short time = 0; time < numSkeletons; time = (short)(time + 1)) {
                int j;
                skeletonMap.put(time, new LinkedHashMap());
                Map frame = (Map)skeletonMap.get(time);
                int numBones = in.readShort();
                for (j = 0; j < numBones; ++j) {
                    short boneId = in.readShort();
                    float locX = in.readFloat();
                    float locY = in.readFloat();
                    float locZ = in.readFloat();
                    float rotX = in.readFloat();
                    float rotY = in.readFloat();
                    float rotZ = in.readFloat();
                    Matrix4f skeleton = VectorHelper.matrix4FromLocRot(locX, -locY, -locZ, rotX, -rotY, -rotZ);
                    frame.put(boneId, skeleton);
                }
                for (j = 0; j < numNodes; j = (short)(j + 1)) {
                    if (frame.containsKey((short)j)) continue;
                    if (time == 0) {
                        throw new IOException("Missing bone definitions in first frame");
                    }
                    frame.put((short)j, ((Map)skeletonMap.get((short)(time - 1))).get((short)j));
                }
                this.frames.add(time, new AnimFrame(this));
                for (short i = 0; i < frame.size(); i = (short)(i + 1)) {
                    this.frames.get(time).addTransforms(i, (Matrix4f)frame.get(i));
                }
            }
        }
        catch (IOException e) {
            throw new GabeNewellException(e);
        }
    }

    private void parseBone(String line, int lineCount) {
        String[] params = line.split("\"");
        int id = Integer.parseInt(RegexPatterns.SPACE_SYMBOL.matcher(params[0]).replaceAll(""));
        String boneName = params[1];
        int parentID = Integer.parseInt(RegexPatterns.SPACE_SYMBOL.matcher(params[2]).replaceAll(""));
        Bone parent = parentID >= 0 ? this.bones.get(parentID) : null;
        this.bones.add(id, new Bone(boneName, id, parent, null));
        ValveStudioModel.print(boneName);
    }

    private void startParsingAnimation(BufferedReader reader, int count, ResourceLocation resloc) throws GabeNewellException {
        int lineCount = count;
        int currentTime = 0;
        ++lineCount;
        String currentLine = null;
        try {
            while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                String[] params = RegexPatterns.MULTIPLE_WHITESPACE.split(currentLine);
                if (params[0].equalsIgnoreCase("time")) {
                    currentTime = Integer.parseInt(params[1]);
                    this.frames.add(currentTime, new AnimFrame(this));
                    continue;
                }
                if (currentLine.startsWith("end")) {
                    this.totalFrames = this.frames.size();
                    ValveStudioModel.print("Total number of frames = " + this.totalFrames);
                    return;
                }
                int boneIndex = Integer.parseInt(params[0]);
                float[] locRots = new float[6];
                for (int i = 1; i < 7; ++i) {
                    locRots[i - 1] = Float.parseFloat(params[i]);
                }
                Matrix4f animated = VectorHelper.matrix4FromLocRot(locRots[0], -locRots[1], -locRots[2], locRots[3], -locRots[4], -locRots[5]);
                this.frames.get(currentTime).addTransforms(boneIndex, animated);
            }
        }
        catch (Exception e) {
            throw new GabeNewellException("an error occurred reading the SMD file \"" + resloc + "\" on line #" + lineCount, e);
        }
    }

    public int requestFrameID() {
        int result = this.frameIDBank++;
        return result;
    }

    private void setBoneChildren() {
        for (int i = 0; i < this.bones.size(); ++i) {
            Bone theBone = this.bones.get(i);
            this.bones.stream().filter(child -> child.parent == theBone).forEach(theBone::addChild);
        }
    }

    public void reform() {
        int rootID = this.owner.body.root.ID;
        for (AnimFrame frame : this.frames) {
            frame.fixUp(rootID, 0.0f);
            frame.reform();
        }
    }

    public void precalculateAnimation(SmdModel model) {
        for (AnimFrame frame1 : this.frames) {
            model.resetVerts();
            AnimFrame frame = frame1;
            for (int j = 0; j < model.bones.size(); ++j) {
                Bone bone = model.bones.get(j);
                Matrix4f animated = frame.transforms.get(j);
                bone.preloadAnimation(frame, animated);
            }
        }
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public void setCurrentFrame(int i) {
        if (this.lastFrameIndex != i) {
            this.currentFrameIndex = i;
            this.lastFrameIndex = i;
        }
    }

    private static String readNullTerm(DataInputStream in) throws IOException {
        StringBuilder str = new StringBuilder();
        char ch = '\u0000';
        do {
            if (ch == '\u0000') continue;
            str.append(ch);
        } while ((ch = in.readChar()) != '\u0000');
        return str.toString();
    }
}

