/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ItemPixelmonSpriteModel
implements IBakedModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("pixelmon:pixelmon_sprite", "inventory");
    IBakedModel iBakedModel;

    public ItemPixelmonSpriteModel(IBakedModel iBakedModel) {
        this.iBakedModel = iBakedModel;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.iBakedModel.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.iBakedModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iBakedModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.iBakedModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new OverrideList();
    }

    class OverrideList
    extends ItemOverrideList {
        private WeakHashMap<String, Boolean> weakSpriteExistenceCheck;

        public OverrideList() {
            super((List)Lists.newArrayList());
            this.weakSpriteExistenceCheck = new WeakHashMap();
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("SpriteName")) {
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                ImmutableMap texMap = ImmutableMap.of((Object)"layer0", (Object)stack.func_77978_p().func_74779_i("SpriteName"));
                ItemLayerModel iModel = ItemLayerModel.INSTANCE.retexture(texMap);
                Optional trsrTransformation = TRSRTransformation.identity().apply(Optional.empty());
                ItemPixelmonSpriteModel.this.iBakedModel = iModel.bake((IModelState)trsrTransformation.get(), DefaultVertexFormats.field_176599_b, textureGetter);
            } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("ndex")) {
                boolean exists;
                NBTTagCompound compound = stack.func_77978_p();
                EnumSpecies species = EnumSpecies.getFromDex(compound.func_74765_d("ndex"));
                byte form = compound.func_74771_c("form");
                boolean shiny = compound.func_74767_n("Shiny");
                int eggCycles = compound.func_74767_n("isEgg") ? species.getBaseStats((IEnumForm)species.getFormEnum((int)form)).eggCycles.intValue() : compound.func_74762_e("eggCycles");
                Gender gender = Gender.getGender(compound.func_74771_c("Gender"));
                String customTexture = compound.func_74779_i("CustomTexture");
                String sprite = eggCycles > 0 ? GuiResources.getEggSprite(species, eggCycles).func_110623_a().replace(".png", "").replace("textures/", "") : GuiResources.getSpritePath(species, (int)form, gender, customTexture, shiny);
                if (!this.weakSpriteExistenceCheck.containsKey(sprite)) {
                    this.weakSpriteExistenceCheck.put(sprite, Pixelmon.proxy.resourceLocationExists(new ResourceLocation("pixelmon", "textures/" + sprite + ".png")));
                }
                if (!(exists = this.weakSpriteExistenceCheck.get(sprite).booleanValue())) {
                    sprite = GuiResources.getSpritePath(species, (int)form, gender, "", shiny);
                }
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                ImmutableMap texMap = ImmutableMap.of((Object)"layer0", (Object)("pixelmon:" + sprite));
                ItemLayerModel iModel = ItemLayerModel.INSTANCE.retexture(texMap);
                Optional trsrTransformation = TRSRTransformation.identity().apply(Optional.empty());
                ItemPixelmonSpriteModel.this.iBakedModel = iModel.bake((IModelState)trsrTransformation.get(), DefaultVertexFormats.field_176599_b, textureGetter);
            }
            return ItemPixelmonSpriteModel.this.iBakedModel;
        }
    }
}

