/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.elements;

import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiSlotBase;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import org.lwjgl.input.Mouse;

class GuiDropDownSlot<T>
extends GuiSlotBase {
    private GuiDropDown<T> dropDown;
    private int dropDownWidth;

    public GuiDropDownSlot(GuiDropDown<T> dropDown, int top, int left, int width, int height) {
        super(top, left, width, height, true);
        this.dropDown = dropDown;
        this.dropDownWidth = width;
    }

    public GuiDropDownSlot(GuiDropDown<T> dropDown, int top, int left, int width, int height, int dropDownWidth) {
        super(top, left, width, height, true);
        this.dropDown = dropDown;
        this.dropDownWidth = dropDownWidth;
    }

    @Override
    protected int getSize() {
        return this.dropDown.options.size();
    }

    @Override
    protected void elementClicked(int index, boolean doubleClicked) {
        this.dropDown.elementClicked(index);
    }

    @Override
    protected boolean isSelected(int element) {
        return element == this.dropDown.selectedIndex;
    }

    @Override
    protected void drawSlot(int index, int x, int yTop, int yMiddle, Tessellator tessellator) {
        this.drawOptionString(index, yTop);
    }

    void drawOptionString(int index, int y) {
        if (index < 0 || index >= this.dropDown.options.size()) {
            return;
        }
        this.drawOptionString(this.dropDown.options.get(index), y);
    }

    void drawOptionString(T option, int y) {
        if (option == null) {
            return;
        }
        int width = this.dropDown.active ? this.dropDownWidth : this.width;
        String optionString = this.dropDown.toOptionString(option);
        optionString = GuiHelper.getLimitedString(optionString, width);
        int color = 0;
        switch (this.dropDown.align) {
            case Left: {
                Minecraft.func_71410_x().field_71466_p.func_78276_b(optionString, this.left + 2, y, color);
                break;
            }
            case Center: {
                GuiHelper.drawCenteredString(optionString, this.left + width / 2, y, color);
                break;
            }
            case Right: {
                GuiHelper.drawStringRightAligned(optionString, this.left + width, y, color);
            }
        }
    }

    @Override
    protected void drawBackground() {
        this.drawBackgroundRect(this.top + 3, this.top + this.height, -5000269);
    }

    void drawBackgroundRect(int top, int bottom, int color) {
        Gui.func_73734_a((int)this.left, (int)top, (int)(this.left + (this.dropDown.active ? this.dropDownWidth : this.width)), (int)bottom, (int)color);
    }

    @Override
    protected float[] get1Color() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    @Override
    protected int[] getSelectionColor() {
        return new int[]{128, 128, 128};
    }

    @Override
    protected int[] get255Color() {
        return null;
    }

    @Override
    public int func_27256_c(int par1, int par2) {
        if (this.inBounds(par1, par2)) {
            int var3 = this.left;
            int var4 = this.left + (this.dropDown.active ? this.dropDownWidth : this.width);
            int var5 = par2 - this.top + this.amountScrolled - 4;
            int var6 = var5 / this.slotHeight;
            return par1 >= var3 && par1 <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
        }
        return -1;
    }

    @Override
    boolean inBounds(int x, int y) {
        int right = (this.dropDown.active ? this.dropDownWidth : this.width) + this.left;
        return x > this.left && x < right && y > this.top && y < this.bottom;
    }

    @Override
    boolean inBoundsScroll(int x, int y) {
        int right = (this.dropDown.active ? this.dropDownWidth : this.width) + this.left;
        return x > this.left && x < right + 6 && y > this.top && y < this.bottom;
    }

    @Override
    void drawSelection(int middleOfSelect, int topLeftOfSelect) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        int leftish = this.left;
        int rightish = this.left + (this.dropDown.active ? this.dropDownWidth : this.width);
        float[] color = this.get1Color();
        GlStateManager.func_179131_c((float)color[0], (float)color[1], (float)color[2], (float)255.0f);
        GlStateManager.func_179090_x();
        VertexFormat vertexFormat = this.opaque ? DefaultVertexFormats.field_181709_i : DefaultVertexFormats.field_181707_g;
        vertexBuffer.func_181668_a(7, vertexFormat);
        if (this.opaque) {
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect + middleOfSelect + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect + middleOfSelect + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
        } else {
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect + middleOfSelect + 2), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect + middleOfSelect + 2), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect - 2), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(80.0, (double)(topLeftOfSelect - 2), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        }
        if (this.opaque) {
            int[] selectionColor = this.getSelectionColor();
            if (selectionColor != null) {
                vertexBuffer.func_181662_b((double)(leftish + 1), (double)(topLeftOfSelect + middleOfSelect + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(selectionColor[0], selectionColor[1], selectionColor[2], 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(rightish - 1), (double)(topLeftOfSelect + middleOfSelect + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(selectionColor[0], selectionColor[1], selectionColor[2], 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(rightish - 1), (double)(topLeftOfSelect - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(selectionColor[0], selectionColor[1], selectionColor[2], 255).func_181675_d();
                vertexBuffer.func_181662_b((double)(leftish + 1), (double)(topLeftOfSelect - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(selectionColor[0], selectionColor[1], selectionColor[2], 255).func_181675_d();
            }
        } else {
            vertexBuffer.func_181662_b((double)(leftish + 1), (double)(topLeftOfSelect + middleOfSelect + 1), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(rightish - 1), (double)(topLeftOfSelect + middleOfSelect + 1), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(rightish - 1), (double)(topLeftOfSelect - 1), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(leftish + 1), (double)(topLeftOfSelect - 1), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    @Override
    public void drawScreen(int mousePosX, int mousePosY, float par3) {
        int middleOfSelect;
        int topLeftOfSelect;
        int index;
        int scrollPosY;
        int scrollPosX;
        GlStateManager.func_179094_E();
        this.mouseX = mousePosX;
        this.mouseY = mousePosY;
        int width = this.dropDown.active ? this.dropDownWidth : this.width;
        int length = this.getSize();
        int posScrollBar = this.left + width;
        int posScrollBar2 = posScrollBar + 6;
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179145_e();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialClickY == -1.0f) {
                boolean flag = true;
                if (mousePosY >= this.top && mousePosY <= this.bottom) {
                    int var8 = this.left;
                    scrollPosX = this.right;
                    scrollPosY = mousePosY - this.top + this.amountScrolled - 4;
                    index = scrollPosY / this.slotHeight;
                    if (this.inBounds(mousePosX, mousePosY) && index >= 0 && scrollPosY >= 0 && index < length) {
                        boolean var12 = index == this.selectedElement && System.currentTimeMillis() - this.lastClicked < 250L;
                        this.elementClicked(index, var12);
                        this.selectedElement = index;
                        this.lastClicked = System.currentTimeMillis();
                    } else if (mousePosX >= var8 && mousePosX <= scrollPosX && scrollPosY < 0) {
                        flag = false;
                    }
                    if (mousePosX >= posScrollBar && mousePosX <= posScrollBar2) {
                        this.scrollMultiplier = -1.0f;
                        topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4);
                        if (topLeftOfSelect < 1) {
                            topLeftOfSelect = 1;
                        }
                        if ((middleOfSelect = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                            middleOfSelect = 32;
                        }
                        if (middleOfSelect > this.bottom - this.top - 8) {
                            middleOfSelect = this.bottom - this.top - 8;
                        }
                        this.scrollMultiplier /= (float)(this.bottom - this.top - middleOfSelect) / (float)topLeftOfSelect;
                    } else {
                        this.scrollMultiplier = 1.0f;
                    }
                    this.initialClickY = flag ? (float)mousePosY : -2.0f;
                } else {
                    this.initialClickY = -2.0f;
                }
            } else if (this.initialClickY >= 0.0f && this.inBoundsScroll(mousePosX, mousePosY)) {
                this.amountScrolled = (int)((float)this.amountScrolled - ((float)mousePosY - this.initialClickY) * this.scrollMultiplier);
                this.initialClickY = mousePosY;
            }
        } else if (this.inBoundsScroll(mousePosX, mousePosY)) {
            try {
                while (!mc.field_71474_y.field_85185_A && Mouse.next()) {
                    int scroll = Mouse.getEventDWheel();
                    if (scroll != 0) {
                        if (scroll > 0) {
                            scroll = -1;
                        } else if (scroll < 0) {
                            scroll = 1;
                        }
                        this.amountScrolled += scroll * this.slotHeight;
                    }
                    mc.field_71462_r.func_146274_d();
                }
                this.initialClickY = -1.0f;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.bindAmountScrolled();
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        scrollPosX = this.left;
        scrollPosY = this.top + 4 - this.amountScrolled;
        this.drawBackground();
        for (index = 0; index < length; ++index) {
            topLeftOfSelect = scrollPosY + index * this.slotHeight;
            middleOfSelect = this.slotHeight - 4;
            if (topLeftOfSelect + 6 > this.bottom || topLeftOfSelect + middleOfSelect - 8 < this.top) continue;
            if (this.isHighlighted(index)) {
                this.drawSelection(middleOfSelect, topLeftOfSelect);
            }
            this.drawSlot(index, scrollPosX, topLeftOfSelect, middleOfSelect, tessellator);
        }
        GlStateManager.func_179097_i();
        int var20 = 4;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179118_c();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179090_x();
        int[] color = this.get255Color();
        if (color != null) {
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)this.left, (double)(this.top + var20), 0.0).func_187315_a(0.0, 1.0).func_181669_b(color[0], color[1], color[2], 0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)(this.top + var20), 0.0).func_187315_a(1.0, 1.0).func_181669_b(color[0], color[1], color[2], 0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(color[0], color[1], color[2], 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(color[0], color[1], color[2], 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)this.left, (double)this.bottom + 2.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(color[0], color[1], color[2], 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)this.bottom + 2.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(color[0], color[1], color[2], 255).func_181675_d();
            vertexBuffer.func_181662_b((double)this.right, (double)(this.bottom + 2 - var20), 0.0).func_187315_a(1.0, 0.0).func_181669_b(color[0], color[1], color[2], 0).func_181675_d();
            vertexBuffer.func_181662_b((double)this.left, (double)(this.bottom + 2 - var20), 0.0).func_187315_a(0.0, 0.0).func_181669_b(color[0], color[1], color[2], 0).func_181675_d();
            tessellator.func_78381_a();
        }
        if ((topLeftOfSelect = this.getContentHeight() - (this.bottom - this.top - 4)) > 0) {
            int leftish;
            middleOfSelect = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
            if (middleOfSelect < 32) {
                middleOfSelect = 32;
            }
            if (middleOfSelect > this.bottom - this.top - 8) {
                middleOfSelect = this.bottom - this.top - 8;
            }
            if ((leftish = this.amountScrolled * (this.bottom - this.top - middleOfSelect) / topLeftOfSelect + this.top) < this.top) {
                leftish = this.top;
            }
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)posScrollBar, (double)this.bottom + 2.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar2, (double)this.bottom + 2.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar2, (double)this.top + 2.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar, (double)this.top + 2.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)posScrollBar, (double)(leftish + middleOfSelect + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar2, (double)(leftish + middleOfSelect + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar2, (double)leftish + 2.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar, (double)leftish + 2.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_181662_b((double)posScrollBar, (double)(leftish + middleOfSelect - 1 + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)(posScrollBar2 - 1), (double)(leftish + middleOfSelect - 1 + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)(posScrollBar2 - 1), (double)leftish + 2.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_181662_b((double)posScrollBar, (double)leftish + 2.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

