/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.badgecase;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.BadgeCaseActionPacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBadgeCase
extends GuiScreen {
    private ResourceLocation upTexture;
    private ResourceLocation downTexture;
    private ResourceLocation registerTexture;
    private ResourceLocation badgeCaseTexture;
    private GuiButton buttonUp;
    private GuiButton buttonRegister;
    private GuiButton buttonDown;
    private final GuiButton[] badgeButtons = new GuiButton[8];
    private int page = 0;
    private int selectedBadge = -1;
    private String owner;
    boolean allowChanges;
    EnumBadgeCase color;
    List<ItemStack> badges;
    public Pokemon[] party = new Pokemon[6];
    private boolean custom;
    private static final int SPRITE_HEIGHT = 40;
    private static final int SPRITE_WIDTH = 40;
    private static final int POKEBALL_HEIGHT = 43;
    private static final int POKEBALL_WIDTH = 44;

    public GuiBadgeCase(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, Pokemon[] party) {
        this.updateBadgeCase(owner, allowChanges, custom, color, badges, party);
    }

    public void func_73866_w_() {
        int i;
        int buttonID = 0;
        int xOffset = (this.field_146294_l - 252) / 2;
        int yOffset = 2;
        this.buttonUp = new GuiButton(buttonID++, xOffset + 37, yOffset + 208, 42, 20, "");
        this.buttonDown = new GuiButton(buttonID++, xOffset + 79, yOffset + 208, 42, 20, "");
        this.buttonRegister = new GuiButton(buttonID++, xOffset + 37, yOffset + 7, 80, 20, "");
        int[] xvalue = new int[]{49, 91, 133, 175};
        for (i = 0; i < 4; ++i) {
            this.badgeButtons[i] = new GuiButton(buttonID++, xOffset + xvalue[i], yOffset + 135, 32, 22, "");
        }
        for (i = 4; i < 8; ++i) {
            this.badgeButtons[i] = new GuiButton(buttonID++, xOffset + xvalue[i - 4], yOffset + 169, 32, 22, "");
        }
        this.field_146292_n.add(this.buttonUp);
        this.field_146292_n.add(this.buttonDown);
        this.field_146292_n.add(this.buttonRegister);
        this.field_146292_n.addAll(Arrays.asList(this.badgeButtons));
        if (!this.allowChanges) {
            this.buttonRegister.field_146124_l = false;
            Arrays.stream(this.badgeButtons).forEach(badge -> {
                badge.field_146124_l = false;
            });
        }
        if (this.owner != null && !this.owner.isEmpty()) {
            this.buttonRegister.field_146124_l = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        int textColor;
        int guiWidth = 210;
        int guiHeight = 235;
        int xOffset = (this.field_146294_l - 205) / 2;
        int yOffset = 2;
        this.field_146297_k.field_71446_o.func_110577_a(this.badgeCaseTexture);
        Gui.func_146110_a((int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)210, (int)235, (float)210.0f, (float)235.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.upTexture);
        Gui.func_146110_a((int)(xOffset + 17), (int)(yOffset + 208), (float)0.0f, (float)0.0f, (int)40, (int)14, (float)40.0f, (float)14.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.downTexture);
        Gui.func_146110_a((int)(xOffset + 59), (int)(yOffset + 208), (float)0.0f, (float)0.0f, (int)40, (int)14, (float)40.0f, (float)14.0f);
        if (this.buttonRegister.field_146124_l) {
            this.field_146297_k.field_71446_o.func_110577_a(this.registerTexture);
            Gui.func_146110_a((int)(xOffset + 16), (int)(yOffset + 10), (float)0.0f, (float)0.0f, (int)80, (int)14, (float)80.0f, (float)14.0f);
        }
        switch (this.color) {
            case Black: {
                textColor = 0x919191;
                break;
            }
            case Blue: {
                if (this.buttonRegister.field_146124_l) {
                    textColor = 0x1919FF;
                    break;
                }
                textColor = 35020;
                break;
            }
            case Green: {
                textColor = 13064;
                break;
            }
            case Pink: {
                if (!this.buttonRegister.field_146124_l) {
                    textColor = 0xFF99FF;
                    break;
                }
                textColor = 0xE600E6;
                break;
            }
            case Red: {
                if (this.buttonRegister.field_146124_l) {
                    textColor = 0xB30000;
                    break;
                }
                textColor = 0xFF4D4D;
                break;
            }
            case White: 
            case Yellow: {
                textColor = 0;
                break;
            }
            default: {
                textColor = 1048575;
            }
        }
        if (this.buttonRegister.field_146124_l) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.badgecase.register", (Object[])new Object[0]), xOffset + 55, yOffset + 13, textColor);
        } else {
            this.func_73732_a(this.field_146297_k.field_71466_p, this.owner, xOffset + 55, yOffset + 13, textColor);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int firstRowHeight = 32;
        int secondRowHeight = 64;
        int collum = 17;
        int offset = 27;
        this.drawPokemon(this.party[0], xOffset, yOffset, collum, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(this.party[3], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        this.drawPokemon(this.party[1], xOffset, yOffset, collum += offset, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(this.party[4], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        this.drawPokemon(this.party[2], xOffset, yOffset, collum += offset, firstRowHeight, collum + 2, firstRowHeight + 2);
        this.drawPokemon(this.party[5], xOffset, yOffset, collum += offset, secondRowHeight, collum + 2, secondRowHeight + 2);
        int count = 0;
        for (GuiButton button : this.badgeButtons) {
            if (this.selectedBadge == this.page * 8 + count) {
                GuiBadgeCase.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)0x46FFFFFF);
            }
            if (this.page * 8 + count < this.badges.size() && button.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                GuiBadgeCase.func_73734_a((int)button.field_146128_h, (int)button.field_146129_i, (int)(button.field_146128_h + button.field_146120_f), (int)(button.field_146129_i + button.field_146121_g), (int)0x32FFFFFF);
            }
            ++count;
        }
        for (i = 0; i < 8 && this.page * 8 + i != this.badges.size(); ++i) {
            int rowX = 34;
            int rowY = i < 4 ? 137 : 170;
            int rowOffset = 42;
            this.field_146296_j.func_180450_b(this.badges.get(this.page * 8 + i), xOffset + rowX + (i + 1 <= 4 ? i * rowOffset : (i - 4) * rowOffset), yOffset + rowY);
        }
        for (i = 0; i < 8; ++i) {
            NBTTagList loreList;
            if (this.page * 8 + i >= this.badges.size() || !this.badgeButtons[i].func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            ItemStack badge = this.badges.get(this.page * 8 + i);
            ArrayList lore = Lists.newArrayList();
            if (badge.func_82837_s()) {
                lore.add(badge.func_82833_r());
            }
            if (badge.func_179543_a("display") != null && badge.func_179543_a("display").func_150297_b("Lore", 9) && !(loreList = badge.func_179543_a("display").func_150295_c("Lore", 8)).func_82582_d()) {
                for (int l1 = 0; l1 < loreList.func_74745_c(); ++l1) {
                    lore.add(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + loreList.func_150307_f(l1));
                }
            }
            if (lore.isEmpty()) continue;
            this.func_146283_a(lore, mouseX, mouseY);
        }
    }

    protected void actionPerformed(GuiButton button, int mouseButton) throws IOException {
        if (button == this.buttonUp) {
            this.pageUp();
            return;
        }
        if (button == this.buttonDown) {
            this.pageDown();
            return;
        }
        if (!this.allowChanges) {
            return;
        }
        if (button == this.buttonRegister) {
            if (this.buttonRegister.field_146124_l) {
                Pixelmon.network.sendToServer((IMessage)new BadgeCaseActionPacket(BadgeCaseActionPacket.Action.REGISTER, this.custom));
                this.buttonRegister.field_146124_l = false;
            }
        } else {
            for (int i = 0; i < this.badgeButtons.length; ++i) {
                if (button != this.badgeButtons[i] || this.badges.size() < this.page * 8 + 1) continue;
                if (mouseButton == 0) {
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + i;
                        continue;
                    }
                    Pixelmon.network.sendToServer((IMessage)new BadgeCaseActionPacket(this.selectedBadge, this.page * 8 + i, this.custom));
                    this.selectedBadge = -1;
                    continue;
                }
                if (mouseButton != 1) continue;
                Pixelmon.network.sendToServer((IMessage)new BadgeCaseActionPacket(this.page * 8 + i, this.custom));
                this.selectedBadge = -1;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
            GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
            this.field_146290_a = guibutton = event.getButton();
            guibutton.func_146113_a(this.field_146297_k.func_147118_V());
            this.actionPerformed(guibutton, mouseButton);
            if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void pageDown() {
        if ((this.page + 1) * 8 >= this.badges.size()) {
            return;
        }
        ++this.page;
    }

    private void pageUp() {
        if (this.page == 0) {
            return;
        }
        --this.page;
    }

    private void drawPokemon(Pokemon pokemon, int xOffset, int yOffset, int ballX, int ballY, int pokeX, int pokeY) {
        if (pokemon != null) {
            GuiHelper.bindPokeballTexture(pokemon.getCaughtBall());
            Gui.func_152125_a((int)(xOffset + ballX), (int)(yOffset + ballY), (float)0.0f, (float)0.0f, (int)44, (int)43, (int)36, (int)36, (float)44.0f, (float)43.0f);
            GuiHelper.bindPokemonSprite(pokemon, this.field_146297_k);
            Gui.func_152125_a((int)(xOffset + pokeX), (int)(yOffset + pokeY - 3), (float)0.0f, (float)0.0f, (int)40, (int)40, (int)36, (int)36, (float)40.0f, (float)40.0f);
        }
    }

    public void updateBadgeCase(String owner, boolean allowChanges, boolean custom, EnumBadgeCase color, List<ItemStack> badges, Pokemon[] party) {
        this.owner = owner;
        this.allowChanges = allowChanges;
        this.custom = custom;
        this.color = color;
        this.badges = badges;
        if (party.length == 6) {
            this.party = party;
        }
        this.badgeCaseTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/badgecase_" + color.toString().toLowerCase() + ".png");
        this.upTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/up_button_" + color.toString().toLowerCase() + ".png");
        this.downTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/down_button_" + color.toString().toLowerCase() + ".png");
        this.registerTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/register_" + color.toString().toLowerCase() + ".png");
    }
}

