/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.camera.GuiCamera;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiMegaItem;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionResponse;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiEvolve
extends GuiCamera {
    public static EntityPixelmon currentPokemon;
    boolean createdEntity = false;
    String newPokemon;
    String oldNickname;
    boolean cancelled = false;
    EvoInfo evoInfo = null;
    int ticks = 0;
    int fadeCount = 0;

    public GuiEvolve() {
        super(CameraMode.Evolution);
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
        }
        if (ClientProxy.battleManager.evolveList.isEmpty()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.checkForPokemon();
        if (currentPokemon == null) {
            Pixelmon.network.sendToServer((IMessage)new EvolutionResponse(this.evoInfo.pokemonUUID));
        }
    }

    private void checkForPokemon() {
        if (this.evoInfo == null) {
            this.evoInfo = ClientProxy.battleManager.evolveList.get(0);
            ClientProxy.battleManager.evolveList.remove(0);
        }
        UUID pokemonUUID = this.evoInfo.pokemonUUID;
        this.newPokemon = this.evoInfo.evolveInto;
        currentPokemon = GuiHelper.getEntity(pokemonUUID);
        Minecraft mc = Minecraft.func_71410_x();
        if (currentPokemon == null) {
            return;
        }
        GuiEvolve.currentPokemon.field_70714_bg.field_75782_a.clear();
        if (ClientProxy.camera != null && PixelmonConfig.useBattleCamera) {
            ClientProxy.camera.field_70128_L = false;
            mc.func_175607_a((Entity)ClientProxy.camera);
            ClientProxy.camera.setTargetRandomPosition(new CameraTargetEntity((Entity)currentPokemon));
        }
        this.oldNickname = currentPokemon.getNickname();
        this.calcSizeDifference();
    }

    private void calcSizeDifference() {
        BaseStats bs = EnumSpecies.getFromNameAnyCase(this.newPokemon).getBaseStats();
        BaseStats currentStats = currentPokemon.getBaseStats();
        if (currentStats == null) {
            return;
        }
        GuiEvolve.currentPokemon.heightDiff = bs.height.floatValue() - currentStats.height.floatValue();
        GuiEvolve.currentPokemon.widthDiff = bs.width.floatValue() - currentStats.width.floatValue();
        GuiEvolve.currentPokemon.lengthDiff = bs.length.floatValue() - currentStats.length.floatValue();
    }

    @Override
    public void func_146278_c(int par1) {
    }

    @Override
    public void func_146276_q_() {
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (currentPokemon != null && GuiEvolve.currentPokemon.evoStage == EvolutionStage.Choice) {
            ++this.ticks;
            if (this.ticks >= 80) {
                Pixelmon.network.sendToServer((IMessage)new EvolutionResponse(currentPokemon.getPokemonData().getUUID(), true));
                GuiEvolve.currentPokemon.evolvingVal = 0;
                GuiEvolve.currentPokemon.evoAnimTicks = 0;
                this.ticks = 0;
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int par3) {
        if (currentPokemon == null) {
            return;
        }
        if (GuiEvolve.currentPokemon.evoStage == EvolutionStage.Choice) {
            int xPos = this.field_146294_l / 2 - 30;
            int yPos = this.field_146295_m / 4 - 15;
            if (mouseX >= xPos && mouseX <= xPos + 60 && mouseY >= yPos && mouseY <= yPos + 17) {
                Pixelmon.network.sendToServer((IMessage)new EvolutionResponse(currentPokemon.getPokemonData().getUUID(), false));
                GuiEvolve.currentPokemon.evoStage = null;
                this.cancelled = true;
            }
        } else if (GuiEvolve.currentPokemon.evoStage == null || this.cancelled) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71439_g.func_71053_j();
            if (!ClientProxy.battleManager.evolveList.isEmpty()) {
                minecraft.func_147108_a((GuiScreen)new GuiEvolve());
            } else if (ServerStorageDisplay.bossDrops != null) {
                minecraft.func_147108_a((GuiScreen)new GuiItemDrops());
            } else if (!ClientProxy.battleManager.newAttackList.isEmpty()) {
                minecraft.func_147108_a((GuiScreen)new GuiBattle());
            } else if (ClientData.openMegaItemGui >= 0) {
                minecraft.func_147108_a((GuiScreen)new GuiMegaItem(ClientData.openMegaItemGui > 0));
            } else {
                Pixelmon.network.sendToServer((IMessage)new BattleGuiClosed());
            }
            minecraft.func_175607_a((Entity)minecraft.field_71439_g);
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String s;
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.evo);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (currentPokemon == null) {
            this.checkForPokemon();
            return;
        }
        if (GuiEvolve.currentPokemon.evoStage != EvolutionStage.PreAnimation && GuiEvolve.currentPokemon.evoStage != EvolutionStage.PostAnimation) {
            GuiHelper.drawImageQuad(this.field_146294_l / 2 - 120, this.field_146295_m / 4 - 40, 240.0, 40.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        if (GuiEvolve.currentPokemon.evoStage == EvolutionStage.PreChoice) {
            s = I18n.func_135052_a((String)"gui.guiEvolve.huh", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(s, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, this.field_146295_m / 4 - 30, 0xFFFFFF);
        }
        if (GuiEvolve.currentPokemon.evoStage == EvolutionStage.Choice) {
            this.oldNickname = currentPokemon.getEscapedNickname();
            s = I18n.func_135052_a((String)"gui.guiEvolve.evolve", (Object[])new Object[]{this.oldNickname});
            this.field_146297_k.field_71466_p.func_78276_b(s, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, this.field_146295_m / 4 - 30, 0xFFFFFF);
            int xPos = this.field_146294_l / 2 - 30;
            int yPos = this.field_146295_m / 4 - 15;
            if (mouseX >= xPos && mouseX <= xPos + 60 && mouseY >= yPos && mouseY <= yPos + 17) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.buttonOver);
            } else {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.button);
            }
            GuiHelper.drawImageQuad(xPos, yPos, 60.0, 17.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            s = I18n.func_135052_a((String)"gui.cancel.text", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(s, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, this.field_146295_m / 4 - 11, 0xFFFFFF);
        }
        if (this.cancelled) {
            s = I18n.func_135052_a((String)"gui.guiEvolve.cancel", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(s, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, this.field_146295_m / 4 - 30, 0xFFFFFF);
        } else if (GuiEvolve.currentPokemon.evoStage == EvolutionStage.End || GuiEvolve.currentPokemon.evoStage == null) {
            s = I18n.func_135052_a((String)"gui.guiEvolve.done", (Object[])new Object[]{this.oldNickname, currentPokemon.getLocalizedName()});
            this.field_146297_k.field_71466_p.func_78276_b(s, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(s) / 2, this.field_146295_m / 4 - 30, 0xFFFFFF);
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }
}

