/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.decorative;

import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStreetLight
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", ef -> ef != EnumFacing.DOWN);
    private static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.2, 0.0, 0.0, 0.8, 1.0, 1.0);
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.2, 1.0, 1.0, 0.8);

    public BlockStreetLight() {
        super(Material.field_151594_q);
        this.field_149785_s = true;
        this.func_149715_a(1.0f);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("street_light");
        this.func_149647_a(PixelmonCreativeTabs.decoration);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k()) {
            case X: {
                return X_AABB;
            }
            case Z: {
                return Z_AABB;
            }
        }
        return STANDING_AABB;
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)worldIn, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(worldIn, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockStreetLight.func_193382_c((Block)block) && (blockfaceshape == BlockFaceShape.SOLID || blockfaceshape == BlockFaceShape.MIDDLE_POLE);
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state)) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            BlockPos blockpos = pos.func_177972_a(enumfacing1);
            boolean flag = false;
            if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
                flag = true;
            } else if (enumfacing$axis.func_176720_b() && !this.canPlaceOn(worldIn, blockpos)) {
                flag = true;
            }
            if (flag) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                i |= 1;
                break;
            }
            case WEST: {
                i |= 2;
                break;
            }
            case SOUTH: {
                i |= 3;
                break;
            }
            case NORTH: {
                i |= 4;
                break;
            }
            default: {
                i |= 5;
            }
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c() instanceof BlockFence) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

