/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.MoveClause;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Download;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Moody;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SpeedBoost;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;

class SpeedPassClause
extends BattleClause {
    private MoveClause batonPassClause = new MoveClause("", "Baton Pass");

    SpeedPassClause() {
        super("speedpass");
    }

    @Override
    public boolean validateSingle(Pokemon pokemon) {
        if (this.batonPassClause.validateSingle(pokemon)) {
            return true;
        }
        boolean hasSpeedBoost = false;
        boolean hasOtherBoost = false;
        AbilityBase ability = pokemon.getAbility();
        if (ability.isAbility((Class<? extends AbilityBase>)Moody.class)) {
            return false;
        }
        if (ability.isAbility((Class<? extends AbilityBase>)SpeedBoost.class)) {
            hasSpeedBoost = true;
        } else if (ability.isAbility((Class<? extends AbilityBase>)Download.class)) {
            hasOtherBoost = true;
        }
        for (Attack attack : pokemon.getMoveset().attacks) {
            if (attack == null) continue;
            if (attack.isAttack("Geomancy")) {
                return false;
            }
            for (EffectBase effect : attack.getMove().effects) {
                if (!(effect.getChance() >= 100.0f) || !(effect instanceof StatsEffect)) continue;
                StatsEffect statsEffect = (StatsEffect)effect;
                StatsType stat = statsEffect.getStatsType();
                if (stat == StatsType.Speed) {
                    hasSpeedBoost = true;
                    continue;
                }
                hasOtherBoost = true;
            }
            if (!attack.isAttack("Belly Drum", "Curse", "Growth", "Magnetic Flux", "Minimize", "Rototiller", "Skull Bash", "Stockpile")) continue;
            hasOtherBoost = true;
        }
        return !hasSpeedBoost || !hasOtherBoost;
    }
}

