/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.clauses;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumNecrozma;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.util.helpers.ArrayHelper;

public class AbilityClause
extends BattleClause {
    private Class<? extends AbilityBase>[] abilities;

    public AbilityClause(String id, Class<? extends AbilityBase> ... abilities) {
        super(id);
        this.abilities = abilities;
        ArrayHelper.validateArrayNonNull(abilities);
    }

    @Override
    public boolean validateSingle(Pokemon pokemon) {
        EnumSpecies species;
        ItemHeld heldItem = pokemon.getHeldItemAsItemHeld();
        if (PixelmonWrapper.canMegaEvolve(heldItem, species = pokemon.getBaseStats().pokemon, pokemon.getForm())) {
            Class<?> megaAbilityClass;
            int form = 0;
            form = species != EnumSpecies.Necrozma ? ((ItemMegaStone)heldItem).getForm(pokemon.getForm()) : EnumNecrozma.ULTRA.getForm();
            BaseStats megaStats = species.getBaseStats(species.getFormEnum(form));
            AbilityBase megaAbility = AbilityBase.getAbility(megaStats.abilities[0]).orElse(null);
            Class<?> clazz = megaAbilityClass = megaAbility == null ? null : megaAbility.getClass();
            if (ArrayHelper.contains(this.abilities, megaAbilityClass)) {
                return false;
            }
        }
        return !pokemon.getAbility().isAbility(this.abilities);
    }
}

