/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CourtChange
extends SpecialAttackBase {
    private static final transient List<StatusType> transferrableStatuses = Arrays.asList(StatusType.Reflect, StatusType.LightScreen, StatusType.AuroraVeil, StatusType.StealthRock, StatusType.Spikes, StatusType.StickyWeb, StatusType.ToxicSpikes, StatusType.Tailwind);

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        BattleControllerBase bc = user.bc;
        HashMap toTransfer = new HashMap();
        for (BattleParticipant battleParticipant : bc.participants) {
            for (PixelmonWrapper pw : battleParticipant.controlledPokemon) {
                ArrayList<StatusBase> transfer = new ArrayList<StatusBase>();
                Iterator<StatusBase> iterator = pw.getStatuses().iterator();
                while (iterator.hasNext()) {
                    StatusBase status = iterator.next();
                    if (!transferrableStatuses.contains((Object)status.type)) continue;
                    transfer.add(status);
                    iterator.remove();
                }
                toTransfer.put(bc.getOppositePokemon(pw), transfer);
            }
        }
        for (Map.Entry entry : toTransfer.entrySet()) {
            PixelmonWrapper pw = (PixelmonWrapper)entry.getKey();
            for (StatusBase status : (List)entry.getValue()) {
                pw.addStatus(status, bc.getOppositePokemon(pw));
            }
        }
        user.bc.sendToAll("pixelmon.effect.courtchange", user.getNickname());
        return AttackResult.proceed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
    }
}

