/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class Assist
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.getParticipant().allPokemon.length == 1) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        ArrayList<Attack> possibleAttacks = this.getPossibleAttacks(user);
        if (!possibleAttacks.isEmpty()) {
            user.useTempAttack(RandomHelper.getRandomElementFromList(possibleAttacks));
            return AttackResult.ignore;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        ArrayList<Attack> possibleAttacks = this.getPossibleAttacks(pw);
        if (possibleAttacks.isEmpty()) {
            return;
        }
        ArrayList<MoveChoice> possibleChoices = MoveChoice.createMoveChoicesFromList(possibleAttacks, pw);
        pw.getBattleAI().weightRandomMove(pw, userChoice, possibleChoices);
    }

    private ArrayList<Attack> getPossibleAttacks(PixelmonWrapper user) {
        ArrayList<Attack> possibleAttacks = new ArrayList<Attack>();
        for (PixelmonWrapper other : user.getParticipant().allPokemon) {
            if (other == user) continue;
            possibleAttacks.addAll(other.getMoveset().stream().filter(attack -> attack != null && !attack.isAttack("Assist", "Baneful Bunker", "Belch", "Bestow", "Bounce", "Celebrate", "Chatter", "Circle Throw", "Copycat", "Counter", "Covet", "Destiny Bond", "Detect", "Dig", "Dive", "Dragon Tail", "Endure", "Feint", "Fly", "Focus Punch", "Follow Me", "Helping Hand", "Hold Hands", "King's Shield", "Mat Block", "Me First", "Metronome", "Mimic", "Mirror Coat", "Mirror Move", "Nature Power", "Phantom Force", "Protect", "Rage Powder", "Roar", "Shadow Force", "Shell Trap", "Sketch", "Sky Drop", "Sleep Talk", "Snatch", "Spiky Shield", "Spotlight", "Struggle", "Switcheroo", "Thief", "Transform", "Trick", "Whirlwind")).collect(Collectors.toList()));
        }
        return possibleAttacks;
    }
}

