/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BattleRegistry {
    private static int battleIndex = 0;
    private static final Map<Integer, BattleControllerBase> battleIDMap = new HashMap<Integer, BattleControllerBase>();
    private static final Map<UUID, BattleControllerBase> battleNameMap = new HashMap<UUID, BattleControllerBase>();
    private static final List<BattleControllerBase> battleList = Collections.synchronizedList(new ArrayList());

    public static BattleControllerBase startBattle(BattleParticipant[] team1, BattleParticipant[] team2, BattleRules rules) {
        BattleControllerBase battle = new BattleControllerBase(team1, team2, rules);
        for (BattleParticipant p : battle.participants) {
            if (p instanceof PlayerParticipant && BattleRegistry.getBattle((EntityPlayer)((PlayerParticipant)p).player) != null) {
                return null;
            }
            PartyStorage partyStorage = p.getStorage();
            if (partyStorage == null || partyStorage.findOne(pokemon -> pokemon.getPixelmonIfExists() != null && pokemon.getPixelmonIfExists().isEvolving()) == null) continue;
            return null;
        }
        BattleStartedEvent battleStartedEvent = new BattleStartedEvent(battle, team1, team2);
        Pixelmon.EVENT_BUS.post((Event)battleStartedEvent);
        if (battleStartedEvent.isCanceled()) {
            return null;
        }
        BattleRegistry.registerBattle(battle);
        for (BattleParticipant battleParticipant : battle.getPlayers()) {
            EntityPlayerMP player = (EntityPlayerMP)battleParticipant.getEntity();
            for (BattleParticipant p2 : battle.participants) {
                if (p2 == battleParticipant) continue;
                PixelmonWrapper pix = p2.allPokemon[0];
                PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player.func_110124_au());
                if (Pixelmon.EVENT_BUS.post((Event)new PokedexEvent(player.func_110124_au(), pix.pokemon, EnumPokedexRegisterStatus.seen, "pokedexKey"))) continue;
                storage.pokedex.set(pix.pokemon, EnumPokedexRegisterStatus.seen);
                storage.pokedex.update();
                if (player == null) continue;
                storage.pokedex.update();
            }
        }
        return battle;
    }

    public static BattleControllerBase startBattle(BattleParticipant[] team1, BattleParticipant[] team2, EnumBattleType type) {
        return BattleRegistry.startBattle(team1, team2, new BattleRules(type));
    }

    public static BattleControllerBase startBattle(BattleParticipant team1, BattleParticipant team2) {
        return BattleRegistry.startBattle(new BattleParticipant[]{team1}, new BattleParticipant[]{team2}, new BattleRules(EnumBattleType.Single));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBattle(BattleControllerBase bc) {
        bc.battleIndex = battleIndex++;
        battleIDMap.put(bc.battleIndex, bc);
        List<BattleControllerBase> list = battleList;
        synchronized (list) {
            battleList.add(bc);
        }
        for (PlayerParticipant p : bc.getPlayers()) {
            battleNameMap.put(p.player.func_110124_au(), bc);
        }
    }

    public static BattleControllerBase getBattle(int index) {
        return battleIDMap.get(index);
    }

    public static BattleControllerBase getBattle(EntityPlayer player) {
        return player == null ? null : battleNameMap.get(player.func_110124_au());
    }

    public static BattleControllerBase getBattleExcludeSpectate(EntityPlayer player) {
        BattleControllerBase bc = BattleRegistry.getBattle(player);
        if (bc == null) {
            return null;
        }
        return bc.hasSpectator(player) ? null : bc;
    }

    public static BattleControllerBase getSpectatedBattle(EntityPlayer player) {
        return battleNameMap.get(player.func_110124_au());
    }

    public static void registerSpectator(Spectator spectator, BattleControllerBase bc) {
        battleNameMap.put(spectator.getEntity().func_110124_au(), bc);
    }

    public static void unregisterSpectator(Spectator spectator) {
        battleNameMap.remove(spectator.getEntity().func_110124_au());
    }

    public static boolean removeSpectator(EntityPlayerMP player) {
        BattleControllerBase battle = battleNameMap.get(player.func_110124_au());
        if (battle != null) {
            return battle.removeSpectator(player);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegisterBattle(BattleControllerBase bc) {
        if (bc != null) {
            battleIDMap.remove(bc.battleIndex);
            Iterator<Spectator> iterator = battleList;
            synchronized (iterator) {
                battleList.remove(bc);
            }
            for (PlayerParticipant p : bc.getPlayers()) {
                battleNameMap.remove(p.player.func_110124_au());
            }
            for (Spectator s : bc.spectators) {
                battleNameMap.remove(s.getEntity().func_110124_au());
            }
        }
    }

    public static void updateBattles() {
        ArrayList<BattleControllerBase> list = new ArrayList<BattleControllerBase>(battleList);
        for (BattleControllerBase base : list) {
            base.update();
        }
    }
}

