/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;

public class PartyStorage
extends PokemonStorage {
    public static final int MAX_PARTY = 6;
    protected Pokemon[] party = new Pokemon[6];
    protected transient StoragePosition cachePosition = new StoragePosition(-1, 0);

    public PartyStorage(UUID uuid) {
        super(uuid);
    }

    @Override
    public Pokemon[] getAll() {
        return Arrays.copyOf(this.party, 6);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            if (this.party[i] == null) continue;
            nbt.func_74782_a("party" + i, (NBTBase)this.party[i].writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public PartyStorage readFromNBT(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            if (nbt.func_74764_b("party" + i)) {
                this.party[i] = Pixelmon.pokemonFactory.create(nbt.func_74775_l("party" + i));
                this.party[i].setStorage(this, new StoragePosition(-1, i));
                continue;
            }
            this.party[i] = null;
        }
        return this;
    }

    @Override
    @Nullable
    public StoragePosition getFirstEmptyPosition() {
        for (int i = 0; i < 6; ++i) {
            if (this.party[i] != null) continue;
            return new StoragePosition(-1, i);
        }
        return null;
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        this.party[position.order] = pokemon;
        this.setNeedsSaving();
        if (pokemon != null) {
            pokemon.setStorage(this, position);
        }
        this.notifyListeners(position, pokemon, new EnumUpdateType[0]);
    }

    public void set(int slot, Pokemon pokemon) {
        this.set(new StoragePosition(-1, slot), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(StoragePosition position) {
        return this.party[position.order];
    }

    @Nullable
    public Pokemon get(int slot) {
        return this.get(this.cachePosition.set(-1, slot));
    }

    public int getSlot(Pokemon pokemon) {
        return this.getSlot(pokemon.getUUID());
    }

    public int getSlot(UUID pokemonUUID) {
        for (int i = 0; i < 6; ++i) {
            if (this.party[i] == null || !Objects.equals(this.party[i].getUUID(), pokemonUUID)) continue;
            return i;
        }
        return -1;
    }

    public List<Pokemon> getTeam() {
        ArrayList<Pokemon> team = new ArrayList<Pokemon>();
        for (Pokemon pokemon : this.party) {
            if (pokemon == null || pokemon.isEgg()) continue;
            team.add(pokemon);
        }
        return team;
    }

    public void heal() {
        for (Pokemon pokemon : this.getTeam()) {
            pokemon.heal();
        }
    }

    @Override
    public void swap(StoragePosition position1, StoragePosition position2) {
        Pokemon temp = this.party[position1.order];
        this.party[position1.order] = this.party[position2.order];
        this.party[position2.order] = temp;
        this.setNeedsSaving();
        if (this.party[position1.order] != null) {
            this.party[position1.order].setStorage(this, position1);
        }
        if (this.party[position2.order] != null) {
            this.party[position2.order].setStorage(this, position2);
        }
        this.notifyListeners(position1, this.party[position1.order], new EnumUpdateType[0]);
        this.notifyListeners(position2, this.party[position2.order], new EnumUpdateType[0]);
    }

    public void swap(int slot1, int slot2) {
        this.swap(new StoragePosition(-1, slot1), new StoragePosition(-1, slot2));
    }

    @Override
    public StoragePosition getPosition(Pokemon pokemon) {
        for (int i = 0; i < 6; ++i) {
            if (this.party[i] != pokemon && (this.party[i] == null || !this.party[i].getUUID().equals(pokemon.getUUID()))) continue;
            return new StoragePosition(-1, i);
        }
        return null;
    }

    @Override
    public List<EntityPlayerMP> getPlayersToUpdate() {
        return new ArrayList<EntityPlayerMP>();
    }

    @Override
    public File getFile() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "pokemon/" + this.uuid.toString() + ".pk");
    }

    public int countAblePokemon() {
        int c = 0;
        for (Pokemon pokemon : this.party) {
            if (pokemon == null || pokemon.getHealth() <= 0 || pokemon.isEgg()) continue;
            ++c;
        }
        return c;
    }

    public int getHighestLevel() {
        int lvl = 1;
        for (Pokemon pokemon : this.party) {
            if (pokemon == null) continue;
            lvl = Math.max(lvl, pokemon.getLevel());
        }
        return lvl;
    }

    public int getAverageLevel() {
        float c = 0.0f;
        int levelSum = 0;
        for (Pokemon pokemon : this.party) {
            if (pokemon == null || pokemon.isEgg()) continue;
            c += 1.0f;
            levelSum += pokemon.getLevel();
        }
        if (c == 0.0f) {
            return 1;
        }
        return (int)((float)levelSum / c);
    }

    public int getLowestLevel() {
        int level = 100;
        for (Pokemon pokemon : this.party) {
            if (pokemon == null || pokemon.isEgg() || pokemon.getLevel() >= level) continue;
            level = pokemon.getLevel();
        }
        return level;
    }

    public EntityPixelmon getAndSendOutFirstAblePokemon(Entity parent) {
        Pokemon pokemon = this.findOne((Pokemon pk) -> {
            EntityPixelmon pixelmon = pk.getPixelmonIfExists();
            if (pixelmon != null && pixelmon.battleController != null) {
                return false;
            }
            return pk.getHealth() > 0 && !pk.isEgg();
        });
        if (pokemon == null) {
            return null;
        }
        return pokemon.getOrSpawnPixelmon(parent);
    }

    public boolean isOldGen(int dimension) {
        boolean oldGenDimension = PixelmonConfig.oldGenDimensions.contains(dimension);
        if (this instanceof PlayerPartyStorage) {
            PlayerPartyStorage pps = (PlayerPartyStorage)this;
            return pps.getMegaItem().canEvolve();
        }
        return oldGenDimension;
    }
}

