/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.CompositeSpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.collection.SpawnInfoCollection;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.items.SpawnInfoItem;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.SpawnInfoNPC;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.wormholes.SpawnInfoWormhole;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.conditions.RarityMultiplier;
import com.pixelmonmod.pixelmon.api.spawning.conditions.SpawnCondition;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnConditionTypeAdapter;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawnInfoTypeAdapter;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class SpawnInfo {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SpawnInfo.class, (Object)new SpawnInfoTypeAdapter()).registerTypeAdapter(SpawnCondition.class, (Object)new SpawnConditionTypeAdapter()).registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).create();
    public static HashMap<String, Class<? extends SpawnInfo>> spawnInfoTypes = new HashMap();
    public String typeID;
    @Deprecated
    private String interval = null;
    public ArrayList<String> tags = Lists.newArrayList((Object[])new String[]{"default"});
    public SpawnCondition condition = new SpawnCondition();
    public SpawnCondition anticondition = null;
    public CompositeSpawnCondition compositeCondition = null;
    public ArrayList<RarityMultiplier> rarityMultipliers = null;
    public int requiredSpace = -1;
    public transient SpawnSet set;
    public float rarity = 0.0f;
    public Float percentage = null;
    public transient ArrayList<LocationType> locationTypes = new ArrayList();
    public ArrayList<String> stringLocationTypes = new ArrayList();

    public SpawnInfo(String typeID) {
        this.typeID = typeID;
    }

    public abstract SpawnAction<? extends Entity> construct(AbstractSpawner var1, SpawnLocation var2);

    public boolean fits(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        if (spawnLocation.diameter < this.requiredSpace) {
            return false;
        }
        if (this.condition != null && !this.condition.fits(this, spawnLocation)) {
            return false;
        }
        if (this.anticondition != null && this.anticondition.fits(this, spawnLocation)) {
            return false;
        }
        if (this.compositeCondition != null && !this.compositeCondition.fits(this, spawnLocation)) {
            return false;
        }
        if (BetterSpawnerConfig.INSTANCE.globalCompositeCondition != null && !BetterSpawnerConfig.INSTANCE.globalCompositeCondition.fits(this, spawnLocation)) {
            return false;
        }
        if (!spawner.fits(this, spawnLocation)) {
            return false;
        }
        for (LocationType locationType : this.locationTypes) {
            if (!spawnLocation.types.contains(locationType)) continue;
            return true;
        }
        return false;
    }

    public void onExport() {
        if (this.condition != null) {
            this.condition.onExport();
        }
        if (this.anticondition != null) {
            this.anticondition.onExport();
        }
    }

    public void onImport() {
        if (this.requiredSpace == -1) {
            this.requiredSpace = 1;
        }
        if (this.interval != null && !this.tags.contains(this.interval)) {
            this.tags.add(this.interval);
        }
        if (this.condition != null) {
            this.condition.onImport();
        }
        if (this.anticondition != null) {
            this.anticondition.onImport();
        }
        if (this.rarityMultipliers != null) {
            this.rarityMultipliers.forEach(RarityMultiplier::onImport);
        }
        if (this.compositeCondition != null) {
            this.compositeCondition.onImport();
        }
        if (this.stringLocationTypes != null && !this.stringLocationTypes.isEmpty()) {
            for (String locationTypeString : this.stringLocationTypes) {
                for (LocationType locationType : LocationType.locationTypes) {
                    if (!locationType.name.equalsIgnoreCase(locationTypeString)) continue;
                    this.locationTypes.add(locationType);
                }
            }
        }
        if (this.locationTypes.isEmpty()) {
            Pixelmon.LOGGER.warn("A SpawnInfo in set: " + this.set.id + " has no LocationTypes. Was this intentional? I doubt it");
        }
    }

    public float getAdjustedRarity(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        float rarity = this.rarity;
        if (this.rarityMultipliers != null && !this.rarityMultipliers.isEmpty()) {
            for (RarityMultiplier rarityMultiplier : this.rarityMultipliers) {
                rarity = rarityMultiplier.apply(this, spawnLocation, rarity);
            }
        }
        for (RarityMultiplier rarityMultiplier : spawner.rarityMultipliers) {
            rarity = rarityMultiplier.apply(this, spawnLocation, rarity);
        }
        for (RarityMultiplier rarityMultiplier : BetterSpawnerConfig.INSTANCE.globalRarityMultipliers) {
            rarity = rarityMultiplier.apply(this, spawnLocation, rarity);
        }
        return rarity;
    }

    public abstract String toString();

    public float calculateNominalRarity() {
        if (this.rarity <= 0.0f) {
            return 0.0f;
        }
        if (this.condition == null) {
            return 75.0f;
        }
        float biomeMultiplier = 1.0f;
        if (this.condition.biomes != null && !this.condition.biomes.isEmpty()) {
            biomeMultiplier = (float)this.condition.biomes.size() / (float)GameRegistry.findRegistry(Biome.class).getEntries().size();
            if (this.condition.biomes.contains(Biomes.field_76771_b) || this.condition.biomes.contains(Biomes.field_76781_i)) {
                biomeMultiplier = 1.0f;
            } else if (this.condition.biomes.contains(Biomes.field_150575_M)) {
                biomeMultiplier = 0.5f;
            }
        }
        float timeMultiplier = 0.0f;
        if (this.condition.times == null || this.condition.times.isEmpty()) {
            timeMultiplier = 1.0f;
        } else {
            if (this.condition.times.contains(WorldTime.DAY)) {
                timeMultiplier += 0.75f;
            }
            if (this.condition.times.contains(WorldTime.NIGHT)) {
                timeMultiplier += 0.75f;
            }
            if (!this.condition.times.contains(WorldTime.DAY) && !this.condition.times.contains(WorldTime.NIGHT)) {
                if (this.condition.times.contains(WorldTime.AFTERNOON) || this.condition.times.contains(WorldTime.MORNING)) {
                    timeMultiplier = 0.5f;
                } else if (this.condition.times.contains(WorldTime.DAWN) || this.condition.times.contains(WorldTime.DUSK)) {
                    timeMultiplier = 0.3f;
                } else if (this.condition.times.contains(WorldTime.MIDNIGHT) || this.condition.times.contains(WorldTime.MIDDAY)) {
                    timeMultiplier = 0.1f;
                } else {
                    return 0.0f;
                }
            }
        }
        if (timeMultiplier > 1.0f) {
            timeMultiplier = 1.0f;
        }
        float weatherMultiplier = 0.0f;
        if (this.condition.weathers == null || this.condition.weathers.isEmpty()) {
            weatherMultiplier = 1.0f;
        } else {
            if (this.condition.weathers.contains((Object)WeatherType.CLEAR)) {
                weatherMultiplier += 0.7f;
            }
            if (this.condition.weathers.contains((Object)WeatherType.RAIN)) {
                weatherMultiplier += 0.3f;
            }
            if (this.condition.weathers.contains((Object)WeatherType.STORM)) {
                weatherMultiplier += 0.1f;
            }
            if (weatherMultiplier > 1.0f) {
                weatherMultiplier = 1.0f;
            }
        }
        return this.rarity * weatherMultiplier * timeMultiplier * (0.5f + biomeMultiplier / 2.0f);
    }

    static {
        spawnInfoTypes.put("collection", SpawnInfoCollection.class);
        spawnInfoTypes.put("pokemon", SpawnInfoPokemon.class);
        spawnInfoTypes.put("npc", SpawnInfoNPC.class);
        spawnInfoTypes.put("item", SpawnInfoItem.class);
        spawnInfoTypes.put("trainer", SpawnInfoNPCTrainer.class);
        spawnInfoTypes.put("wormhole", SpawnInfoWormhole.class);
    }
}

