/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.TimeHandler;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.starter.GuiChooseStarter;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.GuiOpenClose;
import com.pixelmonmod.pixelmon.comm.packetHandlers.StarterListPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.util.Scheduling;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TickHandler {
    boolean screenOpen = false;
    boolean initialised = false;
    public int worldCounter;
    private int ticksSincePlayersCheck = 0;
    static final ArrayList<EntityPlayerMP> playerListForStartMenu = new ArrayList();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.side == Side.SERVER) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PlayerPartyStorage pps = Pixelmon.storageManager.getParty(player);
            Pixelmon.eggHatcher.tick(player, pps);
            Pixelmon.passiveHealer.tick(player, pps);
            Pixelmon.passiveEffects.tick(player, pps);
            if (pps.getLure() != null) {
                Pixelmon.lureExpirer.tick(player, pps, pps.getLureStack());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (ServerStorageDisplay.starterListPacket != null && Minecraft.func_71410_x().field_71462_r == null) {
            try {
                if (ClientStorageManager.party != null && ClientStorageManager.party.countAll() > 0) {
                    ServerStorageDisplay.starterListPacket = null;
                } else {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiChooseStarter());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!(Minecraft.func_71410_x().field_71462_r == null || this.screenOpen && this.initialised || Minecraft.func_71410_x().field_71462_r instanceof GuiChat)) {
            Pixelmon.network.sendToServer((IMessage)new GuiOpenClose(true));
            this.screenOpen = true;
            this.initialised = true;
        } else if (this.screenOpen && Minecraft.func_71410_x().field_71462_r == null || !this.initialised) {
            Pixelmon.network.sendToServer((IMessage)new GuiOpenClose(false));
            this.screenOpen = false;
            this.initialised = true;
            if (Minecraft.func_71410_x().field_71474_y.field_74319_N || !GuiIngameForge.renderHotbar) {
                Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
                GuiIngameForge.renderHotbar = true;
                GuiIngameForge.renderCrosshairs = true;
                GuiIngameForge.renderExperiance = true;
                GuiIngameForge.renderAir = true;
                GuiIngameForge.renderHealth = true;
                GuiIngameForge.renderFood = true;
                GuiIngameForge.renderArmor = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Scheduling.tick();
            return;
        }
        if (this.worldCounter % (PixelmonConfig.timeUpdateInterval * 20) == 0) {
            TimeHandler.changeTime();
        }
        BattleControllerBase.currentAnimations.removeIf(animation -> {
            try {
                if (animation.user.entity == null || animation.target.entity == null) {
                    return true;
                }
                return animation.tickAnimation(++animation.ticks);
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        });
        ArrayList<EntityPlayerMP> arrayList = playerListForStartMenu;
        synchronized (arrayList) {
            if (!playerListForStartMenu.isEmpty() && this.worldCounter % 100 == 0) {
                for (EntityPlayerMP player : playerListForStartMenu) {
                    Pixelmon.network.sendTo((IMessage)new StarterListPacket(), player);
                }
            }
        }
        if (++this.ticksSincePlayersCheck >= 20) {
            this.ticksSincePlayersCheck = 0;
            for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                Pixelmon.storageManager.getParty(player).checkPokerus();
            }
        }
        ++this.worldCounter;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            WorldTime.updateWorldTime(event.world);
            EvolutionQueryList.tick(event.world);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStarterList(EntityPlayerMP player) {
        ArrayList<EntityPlayerMP> arrayList = playerListForStartMenu;
        synchronized (arrayList) {
            if (playerListForStartMenu.contains(player)) {
                return;
            }
        }
        Pixelmon.network.sendTo((IMessage)new StarterListPacket(), player);
        EntityPlayerMP listEntry = null;
        ArrayList<EntityPlayerMP> arrayList2 = playerListForStartMenu;
        synchronized (arrayList2) {
            for (EntityPlayerMP listPlayer : playerListForStartMenu) {
                if (!listPlayer.func_110124_au().equals(player.func_110124_au())) continue;
                listEntry = listPlayer;
                break;
            }
            if (listEntry == null) {
                playerListForStartMenu.add(player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterStarterList(EntityPlayerMP player) {
        EntityPlayerMP listEntry = null;
        ArrayList<EntityPlayerMP> arrayList = playerListForStartMenu;
        synchronized (arrayList) {
            for (EntityPlayerMP listPlayer : playerListForStartMenu) {
                if (!listPlayer.func_110124_au().equals(player.func_110124_au())) continue;
                listEntry = listPlayer;
                break;
            }
            playerListForStartMenu.remove(listEntry);
        }
    }

    @SubscribeEvent
    public void onPlayerJoinedServer(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            PlayerExtraDataStore.sendDisplayPacket();
        }
    }
}

