/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.google.common.base.Predicate;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.Bounds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTravelersBackpack
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final AxisAlignedBB BACKPACK_NORTH_AABB = new Bounds(1, 0, 4, 15, 10, 12).toAABB();
    public static final AxisAlignedBB BACKPACK_SOUTH_AABB = new Bounds(1, 0, 4, 15, 10, 12).toAABB();
    public static final AxisAlignedBB BACKPACK_EAST_AABB = new Bounds(4, 0, 1, 12, 10, 15).toAABB();
    public static final AxisAlignedBB BACKPACK_WEST_AABB = new Bounds(4, 0, 1, 12, 10, 15).toAABB();

    public BlockTravelersBackpack(String name, Material materialIn) {
        super(materialIn);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(1.0f);
        this.func_149752_b(100000.0f);
        this.setHarvestLevel("hand", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        ModBlocks.BLOCKS.add((Block)this);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityTravelersBackpack) {
            if (!worldIn.field_72995_K) {
                if (ConfigHandler.server.enableBackpackBlockWearable) {
                    if (playerIn.func_70093_af()) {
                        TileEntityTravelersBackpack te = (TileEntityTravelersBackpack)worldIn.func_175625_s(pos);
                        if (!CapabilityUtils.isWearingBackpack(playerIn)) {
                            if (worldIn.func_175698_g(pos)) {
                                ItemStack stack = new ItemStack(ModItems.TRAVELERS_BACKPACK, 1, BackpackUtils.convertNameToMeta(te.getColor()));
                                te.transferToItemStack(stack);
                                CapabilityUtils.equipBackpack(playerIn, stack);
                                if (te.isSleepingBagDeployed()) {
                                    EnumFacing bagFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                                    worldIn.func_175698_g(pos.func_177972_a(bagFacing));
                                    worldIn.func_175698_g(pos.func_177972_a(bagFacing).func_177972_a(bagFacing));
                                }
                            } else {
                                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("actions.equip_backpack.fail", new Object[0]));
                            }
                        } else {
                            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("actions.equip_backpack.otherbackpack", new Object[0]));
                        }
                    } else {
                        playerIn.openGui((Object)TravelersBackpack.INSTANCE, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                } else {
                    playerIn.openGui((Object)TravelersBackpack.INSTANCE, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTravelersBackpack && !world.field_72995_K && player != null) {
            TileEntityTravelersBackpack te = (TileEntityTravelersBackpack)tile;
            te.drop(world, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            if (te.isSleepingBagDeployed()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                world.func_175698_g(pos.func_177972_a(facing));
                world.func_175698_g(pos.func_177972_a(facing).func_177972_a(facing));
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos enchTable;
        if (BackpackUtils.getBackpackColor(worldIn, pos).equals("Bookshelf") && (enchTable = BackpackUtils.findBlock3D(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Blocks.field_150381_bn, 2, 2)) != null) {
            if (!worldIn.func_175623_d(new BlockPos((enchTable.func_177958_n() - pos.func_177958_n()) / 2 + pos.func_177958_n(), enchTable.func_177956_o(), (enchTable.func_177952_p() - pos.func_177952_p()) / 2 + pos.func_177952_p()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                worldIn.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)enchTable.func_177958_n() + 0.5, (double)enchTable.func_177956_o() + 2.0, (double)enchTable.func_177952_p() + 0.5, (double)((float)(pos.func_177958_n() - enchTable.func_177958_n()) + worldIn.field_73012_v.nextFloat()) - 0.5, (double)((float)(pos.func_177956_o() - enchTable.func_177956_o()) - worldIn.field_73012_v.nextFloat() - 1.0f), (double)((float)(pos.func_177952_p() - enchTable.func_177952_p()) + worldIn.field_73012_v.nextFloat()) - 0.5, new int[0]);
            }
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return BackpackUtils.getBackpackColor(world, pos).equals("Bookshelf") ? 10.0f : 0.0f;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return BACKPACK_NORTH_AABB;
            }
            case SOUTH: {
                return BACKPACK_SOUTH_AABB;
            }
            case EAST: {
                return BACKPACK_EAST_AABB;
            }
            case WEST: {
                return BACKPACK_WEST_AABB;
            }
        }
        return BACKPACK_NORTH_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(ModItems.TRAVELERS_BACKPACK, 1);
        if (world.func_175625_s(target.func_178782_a()) instanceof TileEntityTravelersBackpack) {
            TileEntityTravelersBackpack te = (TileEntityTravelersBackpack)world.func_175625_s(target.func_178782_a());
            stack = new ItemStack(ModItems.TRAVELERS_BACKPACK, 1, BackpackUtils.convertNameToMeta(te.getColor()));
            te.transferToItemStack(stack);
        }
        return stack;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.TRAVELERS_BACKPACK;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTravelersBackpack();
    }
}

